/*
 * intr.c:  Interrupt and IRQ code
 *
 * (C) 1998 Ramon van Handel, Jens Albretsen, the Alliance Operating System Team
 *
 * HISTORY
 * Date      Author      Rev    Notes
 * 07/11/98  ramon/jens  1.0    First full internal release
 * 04/02/99  ramon       1.1    Modified for ABL
 * 14/07/99  ramon       1.2    Adapted for FreeMWare NULL kernel
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

#include <typewrappers.h>
#include "gdt.h"


extern VOID dummyInt(VOID);


PUBLIC descTable(IDT, 256) {
};


PUBLIC VOID setVector(VOID *handler, UBYTE interrupt, UWORD16 control_major)
/*
 * Set up a vector in the IDT
 *
 * INPUT:
 *     handler:        Address of ISR
 *     interrupt:      Interrupt number
 *     control_major:  Major control byte
 *                     usually (D_INT  + D_PRESENT)
 *                     or      (D_TRAP + D_PRESENT)
 *
 * RETURNS:
 *     none
 */
{
    UWORD16 sel;

    asm( "movw %%cs,%%ax" : "=a" (sel) );

    IDT[interrupt].gate.offset_low    = (UWORD16)(((UWORD32)handler)&0xffff);
    IDT[interrupt].gate.selector      = sel;
    IDT[interrupt].gate.access        = control_major;
    IDT[interrupt].gate.offset_high   = (UWORD16)(((UWORD32)handler)>>16);
}


LOCAL struct
{
    UWORD16       limit __attribute__ ((packed));
    union DTEntry *idt  __attribute__ ((packed));
} loadidt= { (256 * sizeof(union DTEntry) - 1), IDT };


PUBLIC VOID initIntr(VOID)
/*
 * Initialise the kernel interrupt system
 *
 * INPUT:
 *     none
 *
 * RETURNS:
 *     none
 */
{
    DATA i;

    for(i=0;i<256;i++)
        setVector(dummyInt, i, (D_INT+D_PRESENT+D_DPL3));

    asm (
        "lidt (%0)                 \n"   /* Load the IDT              */
        "pushfl                    \n"   /* Clear the NT flag         */
        "andl $0xffffbfff,(%%esp)  \n"
        "popfl                     \n"
        :
        : "r" ((UBYTE *) &loadidt)
    );
}


PUBLIC UDATA missedInts = 0;

asm (
    ".globl dummyInt          \n"
    "dummyInt:                \n"
    "    pushw %ds            \n"
    "    pushw %ss            \n"
    "    popw %ds             \n"
    "    incl missedInts      \n"
    "    popw %ds             \n"
    "    iret                 \n"
);
