/*
 * taskstate.h   structure for task state segments
 *
 * (C) 1998 Ramon van Handel, the Alliance Operating System Team
 *
 * HISTORY
 * Date      Author      Rev    Notes
 * 07/11/98  ramon/jens  1.0    First full internal release
 * 01/01/99  ramon       1.1    TSS now contains i387 FPU state
 * 14/07/99  ramon       1.2    Adapted for FreeMWare NULL kernel
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SYS_TASKSTATE_H
#define __SYS_TASKSTATE_H

/* RESERVED means INTEL RESERVED.  DO NOT USE */

struct TSS {
    UWORD16 back, RESERVED0;      /* Backlink                       */
    UWORD32 esp0;                 /* The CK stack pointer           */
    UWORD16 ss0,  RESERVED1;      /* The CK stack selector          */
    UWORD32 esp1;                 /* The parent KL stack pointer    */
    UWORD16 ss1,  RESERVED2;      /* The parent KL stack selector   */
    UWORD32 esp2;                 /* Unused                         */
    UWORD16 ss2,  RESERVED3;      /* Unused                         */
    UWORD32 cr3;                  /* The page directory pointer     */
    UWORD32 eip;                  /* The instruction pointer        */
    UWORD32 eflags;               /* The flags                      */
    UWORD32 eax, ecx, edx, ebx;   /* The general purpose registers  */
    UWORD32 esp, ebp, esi, edi;   /* The special purpose registers  */
    UWORD16 es,   RESERVED4;      /* The extra selector             */
    UWORD16 cs,   RESERVED5;      /* The code selector              */
    UWORD16 ss,   RESERVED6;      /* The application stack selector */
    UWORD16 ds,   RESERVED7;      /* The data selector              */
    UWORD16 fs,   RESERVED8;      /* And another extra selector     */
    UWORD16 gs,   RESERVED9;      /* ... and another one            */
    UWORD16 ldt,  RESERVED10;     /* The local descriptor table     */
    UWORD16 trap;                 /* The trap flag (for debugging)  */
    UWORD16 io;                   /* The I/O Map base address       */
} __attribute__ ((packed));

#endif
