/*
 *  FreeMWare: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999 - 2000 The FreeMWare Team
 *
 *  virtcode.c:  This file contains the test code to run in the VM
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "virtcode.h"

short *vidmem = (short *) 0xb8000;
int cursor = 0;


void
printstr(char *text)
{
    int i = 0;

    while(text[i])
    {
        if(text[i] == '\n')
        {
            cursor = (cursor / 80 + 1) * 80;
            i++;
            continue;
        }
        vidmem[cursor++] = text[i++] | 0x0700;  // 0x0f00 for bold
        cursor %= 80*25;
    }

    return;
}

void
printchar(char c)
{
  if(c==0xd)
    {
      cursor = (cursor / 80 + 1) * 80;
      return;
    }
  vidmem[cursor++] = c | 0x0700;  // 0x0f00 for bold;
  cursor %= 80*25;
  return;
}

void
printint(int i)
{
    char         s[9];
    const char map[ ] = "0123456789abcdef";
    int          j    = 0;

    if(i&0xf0000000) s[j++] = map[(i>>28)&0xf];
    if(i&0xff000000) s[j++] = map[(i>>24)&0xf];
    if(i&0xfff00000) s[j++] = map[(i>>20)&0xf];
    if(i&0xffff0000) s[j++] = map[(i>>16)&0xf];
    if(i&0xfffff000) s[j++] = map[(i>>12)&0xf];
    if(i&0xffffff00) s[j++] = map[(i>>8)&0xf];
    if(i&0xfffffff0) s[j++] = map[(i>>4)&0xf];
    s[j++] = map[(i>>00)&0xf];
    s[j]   = '\0';

    printstr(s);

    return;
}

void
clear_screen(void) 
{
  int i;

  /* clear the screen */

  for(i=0; i<80*25; i++) vidmem[i] = 0;
}

int
cmpstr(char *s1, char *s2) 
  /* compare two \0 terminated strings
   * return 1 if equal, or 0 if not
   */
{
  int i = 0;
  while(s1[i]) {
    if(s1[i]!=s2[i]) return 0;
    i++;
  }
  if(s2[i]==0)
    return 1;
  return 0;
}
