/*
 *  FreeMWare: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999 - 2000 The FreeMWare Team
 *
 *  virtcode.c:  This file contains the test code to run in the VM
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

/* todo
 * correct history_index
 */

#include "virtcode.h"

#define PROMPT "$ "

char history[200];
int history_index;

int
get_command(void) 
{
  int i,h1;
  char c;

  h1 = history_index;
  do {
    while((i=getkey())==-1);

#ifdef SHOW_SCANCODE
    printstr("Received scancode: ");
    printint(i);
    printstr("\n");
#endif

    c = get_key_code(i);
    if(c) {
      history[history_index++]=c;
      printchar(c);
    }
  }
  while(c!=0xd);
  history[history_index-1]=0;
  return h1;
}

void
print_help(void) 
{
  printstr("Minishell help\n\n");
  printstr("halt ... shut down virtual machine\n");

  return;
}

int
execute_command(int h1) 
{
  if(cmpstr(&history[h1],"help"))
    print_help();
  else if(cmpstr(&history[h1],"halt"))
    /* execute hlt shuts down vm */
    asm("hlt\n");
  else
    printstr(&history[h1]);
  return 0;
}

int
minishell(void) 
{
  history_index=0;

  while (1) {
    printstr(PROMPT);
    execute_command(get_command());
  }

}
