/*
 *  FreeMWare: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The FreeMWare developers team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __PLUGIN_H
#define __PLUGIN_H

#ifdef __cplusplus
extern "C" {
#endif


#include <dlfcn.h>

#define PLUGIN_INIT  "plugin_init"
#define PLUGIN_FINI  "plugin_fini"

#define MAX_ARGC     10

typedef enum
{
    EVT_INPORT, EVT_OUTPORT, EVT_INT,
    EVT_MAX
} event_t;

static const int conflict[EVT_MAX] = { 1, 1, 1, };

typedef int (*handler_t)
    (event_t event, int data, int op_size, int count, void *loc);

struct _plugin_t;

typedef struct _callback_t
{
    event_t   type;
    handler_t handler;
    int base, range;
    struct _plugin_t   *plugin;
    struct _callback_t *next_type;
    struct _callback_t *next_plug;
} callback_t;

typedef struct _plugin_t
{
    int  initialized;
    void *handle;
    int  argc;
    char *name, *args, *argv[MAX_ARGC];
    int  (*init)(struct _plugin_t *plugin, int argc, char *argv[]);
    void (*fini)(void);
    callback_t *callbacks;
    struct _plugin_t *next;
} plugin_t;

extern plugin_t *plugins;

void plugin_load (char *name, char *args);
plugin_t *plugin_unload (plugin_t *plugin);
void plugin_init_all (void);
void plugin_fini_all (void);

callback_t *plugin_alloc (plugin_t *plugin, event_t event, handler_t handler, int base, int range);
void plugin_free  (callback_t *callback);
void plugin_emulate (event_t event, int data, int op_size, int count, void *loc);

typedef int (*iac_handler_t)(void);
void plugin_set_intr (int intr);
int  plugin_acknowledge_intr (void);
void plugin_announce_iac_handler (iac_handler_t handler);

void plugin_abort (void);


#ifdef __cplusplus
};
#endif

#endif /* __PLUGIN_H */
