/*
 * Common definitions for remote server for GDB.
 * Copyright (C) 1993 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <setjmp.h>
#include "freemware.h"
#include "user.h"
#include "plugin.h"

#define NUM_FREGS  0 /* 8 */
#define NUM_REGS   (16+NUM_FREGS)
#define FP_REGNUM  5  /* (ebp) Contains address of executing stack frame */
#define SP_REGNUM  4  /* (usp) Contains address of top of stack          */
#define PC_REGNUM  8  /* (eip) Contains program counter                  */
#define REGISTER_BYTES  ((NUM_REGS-NUM_FREGS)*4 + NUM_FREGS*10)
#define FP0_REGNUM 16
#define REGISTER_BYTE(N) \
  (((N) < FP0_REGNUM) ? ((N) * 4) : ((((N) - FP0_REGNUM) * 10) + 64))

int   read_inferior_memory (int f, char *t, int n);
int   write_inferior_memory (int f, char *t, int n);
void  fetch_inferior_registers (int regno);
void  store_inferior_registers (int regno);
int   mywait (event_t event, int data, int op_size, int count, void *loc);
void  myresume (int st, int sg);

void  error (char *string, ...);
void  perror_with_name (char *string);

extern char *registers;
extern int cont_thread;
extern int general_thread;
extern int thread_from_wait;
extern int old_thread_from_wait;
int   gdb_converse (int sig, char st);

int   putpkt (char *buf);
int   getpkt (char *buf);
void  remote_open (int port);
void  remote_close (void);
void  write_ok (char *buf);
void  write_enn (char *buf, int nn);
void  convert_ascii_to_int (char *f, char *t, int n);
void  convert_int_to_ascii (char *f, char *t, int n);
void  prepare_resume_reply (char *bug, char st, unsigned char sg);
void  decode_m_packet (char *a, unsigned int *b, unsigned int *c);
void  decode_M_packet (char *a, unsigned int *b, unsigned int *c, char *d);
void  enable_async_io (void);
void  disable_async_io (void);

jmp_buf toplevel;

void  perror_with_name (char *st);
