/*
 *  FreeMWare: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The FreeMWare developers team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __USER_H
#define __USER_H

#ifdef __cplusplus
extern "C" {
#endif

#include "freemware.h"
#include "decode.h"

#define  VERSION  "0.1.1-unstable"
#define  BUGSMAIL "freemware@fastxs.net"

typedef struct
{
    int max_memory;
    char guest_file_name[256];
    char dump_file_name[256];
    Bit32u text_address;
    Bit32u data_address;
    Bit32u stack_address;
    Bit32u bss_address;
    int verbose;
    int dump_vm;
    enum i386_asm_syntax syntax;
} config_info_t;

extern config_info_t vm_conf;

extern guest_context_t context;
extern char *ptr;

void vm_init (void);
void vm_fini (void);
void vm_kickstart (void);
void vm_abort (void);
void vm_set_intr (int intr);
void vm_set_sig (void *sig);
void vm_reflect (int signal);
int  vm_alloc_intr (int intr);
int  vm_release_intr (int intr);
void vm_event_loop (void);
int  vm_debug_exception (void);

#ifdef __cplusplus
};
#endif

#endif /* __USER_H */
