/* resultsdb.C
 * John Viega
 *
 * Jan 28-29 2000
 */

#include "resultsdb.H"
#include "fatal.H"
#include "config.H"

static Result *table;

static unsigned int num_entries  = 0;
static unsigned int table_size   = 1000;
static const int TABLE_INCREMENT = 1000;

Result *GetResultTable(unsigned int &n_entries, unsigned int &alloced_size)
{
  n_entries    = num_entries;
  alloced_size = table_size;
  return table;
}

void InitResultsDB()
{
  table = new Result[table_size];
  if(!table)
    OutOfMemory();
}

void ResizeResultsTable()
{
  unsigned int old_size  = table_size;
  Result *old_table      = table;

  table_size += TABLE_INCREMENT;
  table = new Result[table_size];
  if(!table)
    OutOfMemory();

  memcpy(table, old_table, old_size*sizeof(Result));

  delete[] old_table;
}

void AddResult(char *source, int l, Severity s, VulnInfo*v)
{
  Result &r = table[num_entries++];
  r.source  = source;
  r.line    = l;
  r.s       = s;
  r.v       = v;
  r.id      = v->id;

  if(num_entries == table_size) ResizeResultsTable();
}
