/* strpool.C
 * John Viega
 *
 * Note that string pool starts at 1 as far as the outside is concerned.
 * This is so that you can initialize to 0 and know the string hasn't been
 * set yet.
 *
 * Feb 8, 2000
 */

#include "fatal.H"
#include "config.H"

#ifdef ITS4_DEBUG
#include <stdio.h>
#endif

// How big does the string pool start out by default?
#define STRPOOL_BASE_SIZE    16384
// How much should we add to it when we have to grow it?
#define STRPOOL_INCR         8192

char *pool;
int  capacity, incr, size;
void InitStringPool(int c, int i)
{
  capacity = c;
  incr     = i;
  size     = 0;
  pool     = new char[c];
  if(!pool)
    OutOfMemory();
}

void InitStringPool()
{
  InitStringPool(STRPOOL_BASE_SIZE, STRPOOL_INCR);
}

void ExpandPool()
{
#ifdef ITS4_DEBUG
  fprintf(stderr, "Warning: string pool too small.\n");
#endif
  char *newpool = new char[capacity+=incr];
  if(!newpool)
    OutOfMemory();
  memcpy(newpool, pool, size);
  delete[] pool;
  pool = newpool;
}

int AddStringToPool(char *s)
{
  int l = strlen(s) + 1;
  while(capacity < size + l)
    ExpandPool();
  strcpy(&(pool[size]), s); // ITS4: ignore strcpy
  int r  = size + 1;
  size += l;
  return r;
}

char *GetString(int l)
{
  return &pool[l-1];
}

