/*
 *
 * JONAMA - Secure TCP Relay with SSLeay
 *
 * ==================================================================== 
 * Copyright (c) 1999 Henri Gomez. All rights reserved. 
 *
 * --------------------------------------------------------------------
 *
 * "This product includes software developed by 
 * Ralf S. Engelschall <rse@engelschall.com> for use in the
 * mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)." 
 *
 * --------------------------------------------------------------------
 */

#ifdef HAVE_CONFIG_H
#include "config.h" /* the configure script results */
#endif

#define  JONAMA_VERSION VERSION

#include <stdio.h>
#include <stdlib.h>

#include <ssl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>

#ifdef HAVE_STRINGS_H
#include <strings.h>     /* rindex */
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>      /* fork, execvp, exit */
#endif

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>  /* for aix */
#endif

#include <string.h>
#include <resolv.h>
#include <err.h>
#include <stdarg.h>
#include <sys/types.h>
#include <dirent.h>
#include <netdb.h> 
#include <pwd.h>
#include <grp.h> 
#include <signal.h>
#include <ctype.h>  
 

/*
 * Provide reasonable default for some defines
 */
#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE  !FALSE
#endif
#ifndef UNSET
#define UNSET -1
#endif
#ifndef NUL
#define NUL   '\0'
#endif

#ifdef OPENSSL_VERSION_NUMBER
#define SSL_LIBRARY_VERSION OPENSSL_VERSION_NUMBER
#define SSL_LIBRARY_NAME    "OpenSSL"
#else
#ifdef SSLEAY_VERSION_NUMBER
#define SSL_LIBRARY_VERSION SSLEAY_VERSION_NUMBER
#define SSL_LIBRARY_NAME    "SSLeay"
#else
#define SSL_LIBRARY_VERSION 0x0000
#define SSL_LIBRARY_NAME    "OtherSSL"
#endif
#endif


/*
 * Define the SSL options
 */
#define SSL_OPT_NONE           (0)
#define SSL_OPT_RELSET         (1<<0)
#define SSL_OPT_COMPATENVVARS  (1<<1)
#define SSL_OPT_EXPORTCERTDATA (1<<2)
#define SSL_OPT_FAKEBASICAUTH  (1<<3)
#define SSL_OPT_ALL            (SSL_OPT_COMPATENVVAR|SSL_OPT_EXPORTCERTDATA|SSL_OPT_FAKEBASICAUTH)
typedef int OptionType;


/*
 * Define the SSL Protocol options
 */

#define SSL_PROTOCOL_NONE  (0)
#define SSL_PROTOCOL_SSLV2 (1<<0)
#define SSL_PROTOCOL_SSLV3 (1<<1)
#define SSL_PROTOCOL_TLSV1 (1<<2)
#define SSL_PROTOCOL_ALL   (SSL_PROTOCOL_SSLV2|SSL_PROTOCOL_SSLV3|SSL_PROTOCOL_TLSV1)
typedef int ProtocolType;

/*
 * Define the SSL verify levels
 */
typedef enum
{
    SSL_CVERIFY_UNSET           = UNSET,
    SSL_CVERIFY_NONE            = 0,
    SSL_CVERIFY_OPTIONAL        = 1,
    SSL_CVERIFY_REQUIRE         = 2,
    SSL_CVERIFY_OPTIONAL_NO_CA  = 3
} VerifyType;

typedef enum
{
    C_MODE_UNSET		= UNSET,
    C_MODE_NORMAL		= 0,
    C_MODE_BALANCE		= 1
}
ConnectType;

typedef enum 
{
	T_UNSET		= UNSET,
	T_MASTER	= 0,
	T_SERVER	= 1,
	T_CLIENT
}
ThreadMode;

/*
	OpenSSL callback need a keylen
*/

#define	SSL_DEFAULT_KEY_LEN	512

#define	MAX_CONNECTS		32
#define	MAX_SSLS		8	
#define	MAX_PROXIES		32

#ifndef	JONAMA_CONF_FILE
#define	JONAMA_CONF_FILE	"/etc/jonama/conf/jonama.conf"
#endif

#ifndef	JONAMA_DEF_CERT_PATH
#define JONAMA_DEF_CERT_PATH	"/etc/jonama/conf/ssl.crt/cacert.pem"
#endif

#ifndef	JONAMA_DEF_KEY_PATH
#define JONAMA_DEF_KEY_PATH	"/etc/jonama/conf/ssl.key/cakey.pem"
#endif

#define	S_BUFF_SIZE		2048

typedef struct remoteInfo
{
	char *			hostname;
	struct in_addr		hostaddr;
	int			port;
}
remoteInfo;

typedef struct jasslprofile
{
	void *		proxyProfil;

	SSL_CTX *	context;
	char *		name;

	int		usedCount;
	int		protocolLevel;
	int		verifyDepth;
	VerifyType	verifyMode;
	int		keylen;
	long		timeOut;

	char *		certificateFile;
	char *		privateKeyFile;
	char *		CAPath;
	char *		CACertificateFile; 
	char *		cyphers;
}
jasslprofile;


typedef struct japxprofile
{
	jasslprofile *	sslProfil;

	char *		name;
	char *		sslName;

	int		acceptTStart;
	int		acceptTEnd;
	int		acceptTKeepConn;
	int		acceptTDays;

	int		acceptPort;
	remoteInfo	connectTo[MAX_CONNECTS];
	int		numConnects;
	ConnectType	connectMode;

	int		bufferSize;
	int		writeSize;
	int		resolveRemote;
}
japxprofile;


#define	LOG_MINI		0
#define	LOG_NORMAL		1
#define	LOG_ALLWAYS		2

#ifndef INADDR_LOOPBACK
#define	INADDR_LOOPBACK		((u_long)0x7F000001)
#endif

#define	ALLDAYS			-1
#define	EVERY_START_TIME	0
#define	EVERY_END_TIME		9999

/* 
 * Some Defines to clean up source code
 */

#if SSL_LIBRARY_VERSION <  0x00903100L
#define sk_X509_NAME_num(x) 		sk_num(x)
#define sk_X509_NAME_value(x, y) 	sk_value(x, y)
#define sk_X509_NAME_push(x, y) 	sk_push(x, y)
#define sk_X509_NAME_find(x, y) 	sk_find(x, y)
#define sk_X509_NAME_set_cmp_func(x, y)	sk_set_cmp_func(x, y)
#define sk_X509_NAME_new(x)		sk_new(x)
#define STACK_OF_X509_NAME		STACK
#else
#define STACK_OF_X509_NAME		STACK_OF(X509_NAME) 
#endif

#include "jonama_vars.h"
#include "jonama_protos.h"
