/*
 *
 * JONAMA - Secure TCP Relay with SSLeay
 *
 * ====================================================================
 * Copyright (c) 1999 Henri Gomez. All rights reserved.
 *
 * --------------------------------------------------------------------
 *
 * "This product includes software developed by
 * Ralf S. Engelschall <rse@engelschall.com> for use in the
 * mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * --------------------------------------------------------------------
 */

#include "jonama.h"


static char * ja_gettmode()
{
	switch (mode)
	{
		case T_MASTER : return ("MASTER");
		case T_SERVER : return ("SERVER");
		case T_CLIENT : return ("CLIENT");
		default	      : return ("??????");
	}
}


void ja_logme(FILE * pfile, const char * pmsg)
{
	time_t		lt;
	struct tm *     ltmp;
	char		lstr[80];

	if (pfile != NULL)
	{
		time(&lt);
		ltmp = localtime(&lt);
		strftime(lstr, 32, "[%d/%b/%Y %H:%M:%S]", ltmp);
		fprintf(pfile, "%s [%6d] [%s] %s\n", lstr, getpid(), ja_gettmode(), pmsg);
		fflush(pfile);
	}
}

void ja_log(int plevel, const char *pmsg, ...)
{
	va_list		lap;
	char 		lstr[1024];
	
	
	if (plevel < loglevel)
		return;

	va_start(lap, pmsg);
	vsnprintf(lstr, sizeof(lstr), pmsg, lap);
	ja_logme(logfile, lstr);
	va_end(lap);
}


void ja_logerr(int plevel, const char *pmsg, ...)
{
	va_list		lap;
	char 		lstr[1024];
	
	
	if (plevel < errlevel)
		return;

	va_start(lap, pmsg);
	vsnprintf(lstr, sizeof(lstr), pmsg, lap);
	ja_logme(errlogfile, lstr);
	va_end(lap);
}


void ja_logoserr(int plevel, const char *pmsg, ...)
{
	va_list		lap;
	char 		lstr[1024];
	char		iostr[512];
	
	
	if (plevel < errlevel)
		return;

	va_start(lap, pmsg);
	vsnprintf(lstr, sizeof(lstr), pmsg, lap);
	sprintf(iostr, " (%s #%d)", strerror(errno), errno);
	strcat(lstr, iostr);
	ja_logme(errlogfile, lstr);
	va_end(lap);
}


void ja_log_init(const char * plogpath, const char * perrpath)
{
	if (log2stdx)
	{
		errlogfile = stderr;
		logfile	   = stderr;
		return;
	}

	if (perrpath != NULL)
	{
		if (errlogfile)
			fclose(errlogfile);

		errlogfile = fopen(perrpath, "a");

		if (! errlogfile)
		{
			errlogfile = stderr;	
			ja_logerr(LOG_ALLWAYS, "Can't open %s, error Log to stderr", perrpath);
		}
	}
	else
		errlogfile = stderr;

	if (plogpath != NULL)
	{
		if (logfile)
			fclose(logfile);

		logfile = fopen(plogpath, "a");

		if (! plogpath)
		{
			logfile = stderr;
			ja_log(LOG_ALLWAYS, "Can't open %s, Log to stderr", plogpath);
		}
	}
}
 
