/*
 *
 * JONAMA - Secure TCP Relay with SSLeay
 *
 * ====================================================================
 * Copyright (c) 1999 Henri Gomez. All rights reserved.
 *
 * --------------------------------------------------------------------
 *
 * "This product includes software developed by
 * Ralf S. Engelschall <rse@engelschall.com> for use in the
 * mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * --------------------------------------------------------------------
 */

#include "jonama.h"

static char * conffile;


static void ja_init()
{
	jasslprofile *	ljassl;
	japxprofile *	ljapx;
	int		i;


	for (i = 0, ljassl = sslprofiles_pool; i < MAX_SSLS; i++, ljassl++)
	{
		ljassl->name			= NULL;
		ljassl->usedCount		= 0;
		ljassl->proxyProfil		= NULL;
		ljassl->protocolLevel		= SSL_PROTOCOL_ALL;
		ljassl->context			= NULL;
		ljassl->verifyDepth		= 0;
		ljassl->verifyMode		= SSL_CVERIFY_NONE;
		ljassl->certificateFile		= NULL;
		ljassl->privateKeyFile		= NULL;
		ljassl->CAPath			= NULL;
		ljassl->CACertificateFile	= NULL;
		ljassl->keylen			= SSL_DEFAULT_KEY_LEN;
	}

	for (i = 0, ljapx = pxprofiles_pool; i < MAX_PROXIES; i++, ljapx++)
	{
		ljapx->name		= NULL;
		ljapx->sslName		= NULL;
		ljapx->sslProfil	= NULL;
		ljapx->acceptPort	= 8888;
		ljapx->numConnects	= 0;
		ljapx->connectMode	= C_MODE_NORMAL;
		ljapx->bufferSize	= S_BUFF_SIZE;
		ljapx->writeSize	= S_BUFF_SIZE;
		ljapx->resolveRemote	= 0;
		ljapx->acceptTStart	= EVERY_START_TIME;
		ljapx->acceptTEnd	= EVERY_END_TIME;
		ljapx->acceptTKeepConn	= 1;
        	ljapx->acceptTDays	= ALLDAYS;
	}
}
	

static void ja_cleanup()
{
	int		i;
	jasslprofile *	lja;

	ja_log(LOG_ALLWAYS, "Cleaning up services pool... (#%d)", numSslp);

	for (i = 0, lja = sslprofiles_pool; i < numSslp; i++, lja++)
		SSL_CTX_free(lja->context);
	
	numSslp = 0;
	numPxp = 0;
}


static void ja_postinit(int first)
{
	char 	llogp[256];
	char	lerrp[256];


	sprintf(llogp, "%s/%s", logPath, logFileName);
	sprintf(lerrp, "%s/%s", logPath, errorFileName);
	ja_log_init(llogp, lerrp);
	ja_log(LOG_ALLWAYS, "Initializing...");

	if (first)
		ja_init_ssl();
}


static int ja_openbind(japxprofile * pja)
{
        struct sockaddr_in      listin;
	int			listensock;


        listensock = socket(AF_INET, SOCK_STREAM, 0);

        if (listensock < 0)
        {
                ja_logerr(LOG_ALLWAYS, "Unable to create socket.");
                return (-1);
        }

        memset(&listin, 0, sizeof(listin));
        listin.sin_family        = AF_INET;
        listin.sin_addr.s_addr  = htonl(INADDR_ANY);
        listin.sin_port         = htons(pja->acceptPort);

        if (bind(listensock, &listin, sizeof(listin)) < 0)
        {
                ja_logoserr(LOG_ALLWAYS, "Can't bind");
                return (-2);
        }

	return (listensock);
}


static jasslprofile * ja_locatesslprofile(char * psslname)
{
	int		i; 
	jasslprofile *	ljassl;


	for (i = 0, ljassl = sslprofiles_pool; i < numSslp; i++, ljassl++)
	{
		if (! strcmp(psslname, ljassl->name))
			return(ljassl);
	}

	return (NULL);
}


static void ja_marksslprofiles()
{
	int		i;
	japxprofile *	ljapx;
	jasslprofile *	ljassl;


	for (i = 0, ljapx = pxprofiles_pool; i < numPxp; i++, ljapx++)
	{
		if (ljapx->sslName)
		{
			ljassl = ja_locatesslprofile(ljapx->sslName);

			if (ljassl)
			{
				ljassl->usedCount++;
				ljapx->sslProfil = ljassl;
			}
		}
	}
}

	
static void ja_run(int first)
{
	int		i;
	int		listensock;
	jasslprofile *	ljassl;
	japxprofile *	ljapx;


	ja_init();
	ja_processConfFile(conffile);
	ja_postinit(first);

	/*
 	 * Map SSL Profile to Proxies
	 */

	ja_marksslprofiles();

	if (first)
	{
		close(0);
		
		if (! log2stdx)
		{
			close(1);
			close(2);
		}
	}

	for (i = 0, ljassl = sslprofiles_pool; i < numSslp; i++, ljassl++)
	{
		/*
		 * Keep only used SSL Profiles
		 */

		if (ljassl->usedCount)
			ja_new_context(ljassl);
	}

	for (i = 0, ljapx = pxprofiles_pool; i < numPxp; i++, ljapx++)
	{	
		listensock = ja_openbind(ljapx);

		if (listensock >= 0)
			ja_server(ljapx, listensock);
	}
}

static void usage()
{
	printf("usage: jonama args\n\n"
	       " -D             - daemonize\n"
	       " -f config.file - alternate config file\n"
	       " -s             - log to stderr instead of file\n"
	       "\n\n");

	exit(0);
}

static void ja_sgnhuphandler(int sig)
{
	switch (mode)
	{
		case T_MASTER :
		{
			ja_log(LOG_ALLWAYS, "Signal %d received, processing...", sig);
			ja_cleanup();
			ja_run(0);
			break;
		}

		case T_SERVER :	
		{
			ja_log(LOG_ALLWAYS, "Signal %d received, exiting...", sig);
			exit(1);
		}

		case T_CLIENT :
		{
			ja_log(LOG_ALLWAYS, "Signal %d received, ignoring...", sig);
			break;
		}

		default	     :
		{
			ja_log(LOG_ALLWAYS, "Signal %d received, aborting since mode not set (how ???)", sig);
			break;
		}

	}
}		
	
static void ja_processArgs(int argc, char **argv)
{
	int	i;


	for (i = 1; i < argc; i++)
	{
		if (argv[i][0] == '-')
		{
			switch (argv[i][1])
			{
				case 'D' :	daemonize = 1;	break;
				case 'f' :	
				{
					if (i < argc)
						conffile = argv[i+1];

					break;
				}

				case 's' :
				{
					log2stdx = 1;
					break;
				}

				default : usage();
			}
		}
	}
}


int main(int argc, char **argv)
{
	mode = T_MASTER;
	conffile = JONAMA_CONF_FILE;

	signal(SIGPIPE, SIG_IGN);
	signal(SIGCHLD, SIG_IGN);
	signal(SIGHUP,  ja_sgnhuphandler);

	ja_processArgs(argc, argv);

	if (daemonize)
	{
		switch (fork())
		{
			case -1 : fprintf(stderr, "cannot fork...\n");	exit(1);
			case  0 : break;
			default : exit(0);
		}
	}
	
	
	ja_run(1);

	for (;;)
		sleep(1);

	exit(0);
}

