/*
 *
 * JONAMA - Secure TCP Relay with SSLeay
 *
 * ====================================================================
 * Copyright (c) 1999 Henri Gomez. All rights reserved.
 *
 * --------------------------------------------------------------------
 *
 * "This product includes software developed by
 * Ralf S. Engelschall <rse@engelschall.com> for use in the
 * mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * --------------------------------------------------------------------
 */

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* ja_main.c */
extern int main P_((int argc, char **argv));

/* ja_log.c */
extern void ja_logme P_((FILE *pfile, const char *pmsg));
extern void ja_log P_((int plevel, const char *pmsg, ...));
extern void ja_logerr P_((int plevel, const char *pmsg, ...));
extern void ja_logoserr P_((int plevel, const char *pmsg, ...));
extern void ja_log_init P_((const char *plogpath, const char *perrpath));

/* ja_ssl.c */
extern void ja_DumpSessionInfo(SSL_SESSION * pSSL);
extern void ja_LogTracingState P_((SSL *pssl, int pwhere, int prc));
extern STACK_OF_X509_NAME *ja_setup_CAs P_((jasslprofile *pwp));
extern void ja_init_ssl P_((void));
extern int ja_new_context P_((jasslprofile *pwp));

/* ja_conf.c */
extern void ja_processConfFile(char *pathconf);

/* ja_client.c */
extern char * check_remote(japxprofile * pwp, struct sockaddr_in * pin);
extern int ja_client(japxprofile *pwp, int psocket, struct sockaddr_in * pin);

/* ja_server.c */
extern int ja_server(japxprofile *pwp, int plistensock);
