/*
 *
 * JONAMA - Secure TCP Relay with SSLeay
 *
 * ====================================================================
 * Copyright (c) 1999 Henri Gomez. All rights reserved.
 *
 * --------------------------------------------------------------------
 *
 * "This product includes software developed by
 * Ralf S. Engelschall <rse@engelschall.com> for use in the
 * mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * --------------------------------------------------------------------
 */

#include "jonama.h"


static void ja_server_init(japxprofile * pja)
{
	if (pja->sslProfil)
		pja->sslProfil->proxyProfil = pja;

	if (geteuid())
	{
		ja_logerr(LOG_ALLWAYS, "I must be run by root");
		exit(1);
	}

	if (chdir(chrootPath))
	{
		ja_logoserr(LOG_ALLWAYS, "Can't chdir to %s", chrootPath);
		exit(1);
	}

	if (chroot(chrootPath))
	{
		ja_logoserr(LOG_ALLWAYS, "Can't chroot to %s", chrootPath);
		exit(1);
	}

	if (setgid(group))
	{
		ja_logoserr(LOG_ALLWAYS, "Can't setgid to %d", group);
		exit(1);
	}

	if (setuid(user))
	{
		ja_logoserr(LOG_ALLWAYS, "Can't setuid to %d", user);
		exit(1);
	}

	ja_log(LOG_NORMAL, "Server chrooted and setuied");
}


static int ja_checkdatetime(japxprofile * pja)
{
	time_t		lt;
	struct tm *	ltmp;
	int		lct;

	time(&lt);
	ltmp = localtime(&lt);

	if (! (pja->acceptTDays & (1 << ltmp->tm_wday)))
		return(-1);

	lct = ltmp->tm_hour * 100 + ltmp->tm_min;

	if ((lct >= pja->acceptTStart) && (lct <= pja->acceptTEnd))
		return(0);

	return(-2);
}


int ja_server(japxprofile * pja, int plistensock)
{
	int			socksize;
	int			newsock;
	int			err;
	struct sockaddr_in	incomin;
	char *			hname;
	char *			cause;
	char			logp[256];
	char			errp[256];


	switch(fork())
	{
		case -1:	ja_logerr(LOG_ALLWAYS, "fork failed");      break;
		case  0:	break;
                default:        close(plistensock); return(0);
        }

	mode = T_SERVER;

	ja_server_init(pja);
	sprintf(logp, "%s/%s-%s", logPath, pja->name, logFileName);
	sprintf(errp, "%s/%s-%s", logPath, pja->name, errorFileName);
	ja_log_init(logp, errp);
	
	ja_log(LOG_NORMAL, "Session %s started, listening port %d", pja->name, pja->acceptPort);

	if (listen(plistensock, 5) < 0)
	{
		ja_logoserr(LOG_ALLWAYS, "Can't listen");
		return (-3);
	}

	socksize = sizeof(incomin);

	for (;;)
	{
		if ((newsock = accept(plistensock, &incomin, &socksize)) < 0)
		{
			ja_logoserr(LOG_ALLWAYS, "Can't accept");
			sleep(5);
			continue;
		}	
	
		/* 
		 * Check if allowed to connect at this time/date
		 */

		if ((err = ja_checkdatetime(pja)) < 0)
		{
			hname = check_remote(pja, &incomin);

			if (! hname)
				hname = "unk";

			if (err == -1)
				cause = "day";
			else
				cause = "time";

			ja_logerr(LOG_NORMAL, "Access Denied by %s rule for %s at port %d", cause, hname, pja->acceptPort);
			close(newsock);
		}
		else
		{	
			switch(fork())
			{
				case -1:	ja_logoserr(LOG_ALLWAYS, "fork failed");	break;
				case  0:
				{
					close(plistensock);
					ja_client(pja, newsock, &incomin);
					exit(0);
					break;
				}

				default:	close(newsock);

			}
		}
	}
}
