/*
 * ARNS - A Remote Network Server for AppleTalk
 * 
 * Allow a remote client to become a node on a local
 * EtherTalk network using IP as the transport layer.
 *
 * Copyright (c) 1992, The University of Melbourne.
 * All Rights Reserved. Permission to publicly redistribute this package
 * or to use any  part of this software for any purpose, other than that
 * intended by the original distribution, *must*  be obtained in writing
 * from the copyright owner.
 *
 * This software is supplied "as is" without express or implied warranty.
 *
 * djh@munnari.OZ.AU
 *
 * $Author: djh $
 * $Revision: 1.11 $
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#if defined (ultrix) || defined (AIX)
#include <sys/file.h>
#else	/* ultrix || AIX */
#include <sys/fcntl.h>
#endif	/* ultrix || AIX */
#ifdef	AIX
#include <sys/select.h>
#endif	/* AIX */
#include <sys/ioctl.h>
#include <netinet/in.h>
#if (!(defined(sony_news) || defined(__386BSD__)))
#include <netinet/tcp.h>
#endif	/* sony_news || __386BSD__ */
#include <signal.h>
#include <netdb.h>
#include <time.h>
#include <pwd.h>
#ifdef	NeXT
#include <libc.h>
#endif	/* NeXT */

/* map compatible functions */

#ifdef	SOLARIS
#define MAPFUNCS
#endif	/* SOLARIS */

#ifdef	MAPFUNCS
#define bcopy(a,b,s)	memcpy((char *)(b),(char *)(a),(s))
#define bcmp(a,b,s)	memcmp((char *)(a),(char *)(b),(s))
#define bzero(a,s)	memset((char *)(a),0,(s))
#define rindex(s,c)	strrchr((char *)(s),(c))
#define index(s,c)	strchr((char *)(s),(c))
#endif	MAPFUNCS

#ifdef	hpux
#define POSIX
#endif	/* hpux */

/* misc numbers		*/

#define ARNS_PORT	384		/* Incoming client UDP port 	*/
#define MAXNODES	256		/* Node slots per network #	*/
#define MAXFILTERS	100		/* Max entries for IP filter	*/
#define SKTBUFSIZ	32768		/* SO_RCVBUF buffer size	*/
#define HDRSZ		32		/* room to prepend various hdrs	*/

#define AARPReq		1		/* Address Resolution Request	*/
#define AARPResp	2		/* Address Resolution Response	*/
#define AARPProbe	3		/* Address Resolution Probe	*/

#define INFOTimer	5		/* server ZIP/Info proc (1 sec)	*/
#define RTMPTimer	50		/* server RTMP process (10 sec)	*/
#define NBPTimer	600		/* server NBP process (120 sec)	*/
#define TICKLETimer	300		/* srvr TICKLE process (60 sec)	*/

#define IDLECount	5		/* # tickles before disconnect	*/
#define IDLETime	300		/* connection IDLE time (5 min)	*/
#define NBPCACHETIMEOUT	300		/* lives in local cache (5 min)	*/

#define NBPCacheSkt	0x42		/* server static skt for NBP	*/
#define ECHOReqSkt	0x43		/* server static skt for ECHO	*/
#define ZIPReqSkt	0x44		/* static skt for GetNetInfo	*/ 

#define NBPIDENT	0x01		/* client NBP lookup ID		*/

#define NBPBRREQ	0x01		/* NBP broadcast request	*/
#define NBPLKUPREQ	0x02		/* NBP lookup request packet	*/
#define NBPLKUPREPLY	0x03		/* NBP lookup reply packet	*/
#define NBPFWDREQ	0x04		/* NBP forward request		*/

#define nbpEquals	'='
#define nbpWild		0xc5

#define NBPTYPE		"\014RemoteClient"
#define ECHOMSG		"[Are You There ?]"

#define P2STARTUP	65280

#define BCAST		0xff

#define PHASE1		0x01
#define PHASE2		0x02

#define SDDP		0x01
#define LDDP		0x02

#define RTMP		0x01
#define NBP		0x02
#define ATP		0x03
#define AEP		0x04
#define RTMPR		0x05
#define ZIP		0x06
#define ADSP		0x07
#define SNMP		0x08

#define TREQ		0x40
#define TRESP		0x80
#define TREL		0xc0
#define FNMSK		0xc0

#define XO		0x20
#define EOM		0x10
#define STS		0x08

#define TREL030		0x00
#define TREL060		0x01
#define TREL120		0x02
#define TREL240		0x03
#define TREL480		0x04
#define TRELMSK		0x07

#define GETMYZONE	0x07
#define GETZONELIST	0x08
#define GETLOCALZONES	0x09

#define IDLEN		0x08

/* ARNS debug flags	*/

#define RTMPDEBUG	0x0001
#define NBPDEBUG	0x0002
#define ECHODEBUG	0x0004
#define ZIPDEBUG	0x0008
#define IPDEBUG		0x0010
#define ETHDEBUG	0x0020
#define ROUTEDEBUG	0x0040
#define PKTDEBUG	0x0080
#define TIMERDEBUG	0x0100
#define AARPDEBUG	0x0200

/* ARNS packet types	*/

#define ARNS_CONNECT	10
#define ARNS_DDPDATA	11
#define ARNS_TICKLE	12
#define ARNS_ERROR	13

/* connect negotiation	*/

#define CONN_PROBE	1
#define CONN_REQUEST	2
#define CONN_NETINFO	3
#define CONN_DISCONN	4
#define CONN_GOODBYE	5
#define CONN_REDIRECT	6
#define CONN_REDIRADDR	7
#define CONN_REDIRECTED	8

/* tickle packets	*/

#define ECHO_REQUEST	1
#define ECHO_REPLY	2

/* result/error returns	*/

#define ERR_WAITING	1
#define ERR_NODEUSED	2
#define ERR_NEEDPASS	3
#define ERR_BADPASS	4
#define ERR_ILLEGAL	5
#define ERR_TOOBUSY	6
#define ERR_UNKNOWN	7
#define ERR_BADADDR	8
#define ERR_BADRQST	9

#define PASS_NONE	0
#define PASS_CLEAR	1
#define PASS_MUNGE	2
#define PASS_USERPW	3

#define LOG_MESSAGE	0
#define LOG_REQUEST	1
#define LOG_CONNECT	2
#define LOG_DISCONN	3
#define LOG_TIMEOUT	4
#define LOG_BADPASS	5
#define LOG_REDIRECT	6

/* structure defns	*/

struct nodeTab {
	struct sockaddr remote;		/* address of remote node	*/
	int fromlen;			/* length of remote address	*/
	short connType;			/* node connectivity		*/
#define ARNS_UNUSED	0			/* UNCONNECTED		*/
#define ARNS_PENDING	1			/* Address resolving	*/
#define ARNS_ETALK	2			/* DDP in EtherTalk	*/
#define ARNS_IPLAP	3			/* DDP in UDP/IP	*/
#define ARNS_BRIDGE	4			/* That's me		*/
	short encapType;		/* encapsulation of outgoing pkt*/
#define SEND_IPLAP	0			/* req,dst,src,typ,data	*/
#define SEND_IPTALK1	1			/* IPTalk to 200 range	*/
#define SEND_IPTALK2	2			/* IPTalk to 768 range	*/
	short aarpState;		/* validity of ethernet address	*/
#define AARP_UNKNOWN	0			/* address not valid	*/
#define AARP_PENDING	1			/* AARP lkup in progress*/
#define AARP_VALID	2			/* address OK		*/
	short aarpCount;		/* count of AARPs left to send	*/
	short aarpFunction;		/* AARP Request or Probe	*/
	u_char eaddr[6];		/* ethernet addr of this node	*/
	unsigned long inpkts;		/* stats: # packets received	*/
	unsigned long outpkts;		/* stats: # packets sent	*/
	short nbpTimer;			/* time to next NBP probe	*/
	short idleTimer;		/* time to next ECHO tickle	*/
	short idleCount;		/* number of tickles sent	*/
	time_t heardFrom;		/* last heard from		*/
};

/*
 * entity list ordered by NBP objects
 *
 */

struct cacheTuple {
	u_short entNet;
	u_char entNode;
	u_char entSkt;
	u_char entEnum;
	char nbpObj[34];
	time_t when;
	struct cacheTuple *next;
};

/*
 * the NBP cache is a list sorted by NBP type
 *
 */

struct cacheEntry {
	char nbpType[34];
	struct cacheTuple *list;
	struct cacheEntry *next;
};

/*
 * IP filter list
 *
 */

struct ipFilter {
	short perm;
	unsigned long mask;
	unsigned long addr;
};

/*
 * Read Data structure
 *
 */

#define NUMRDS	32

struct RDS {
	u_short dataLen;
	u_char *dataPtr;
};
