/*******************************************************************************
 *
 *  Copyright (c) 1999 by Thierry Lelegard
 *
 *  This software is covered by the "GNU GENERAL PUBLIC LICENSE" (GPL),
 *  version 2, June 1991. See the file named COPYING for details.
 *
 *  Project: VMSCD - OpenVMS CD-ROM Utility for Linux
 *  File:    copy.h
 *  Author:  Thierry Lelegard
 *
 *
 *  Abstract
 *  --------
 *  This module implements the file copy operations.
 *
 *
 *  Modification History
 *  --------------------
 *  26 Dec 1999 - Thierry Lelegard (lelegard@club-internet.fr)
 *                Creation of the file.
 *
 *
 *******************************************************************************
 */


#ifndef COPY_H_LOADED
#define COPY_H_LOADED 1

/*
 *  The following structure describes the list options.
 *  Binary zeroes are an acceptable default value.
 */

typedef struct {
    int dest_dir;      /* Boolean: destination path is a directory */
    int verbose;       /* Boolean: log file names */
    FILE *out;         /* Command output file  */
    int all_files;     /* Boolean: copy all files, including system ones */
    int recurse;       /* Boolean: recurse into subdirectories */
    int text_mode;     /* Boolean: convert "text files" to unix text format */
    int text_only;     /* Boolean: copy "text files" only */
    int create_sfa;    /* Boolean: create "set file/attribute" DCL procedures */
    int create_ucx;    /* Boolean: create attribute files for UCX NFS client */
} copy_opt_t;

/* 
 *  The following routine performs the copy command.
 *  If dest is NULL, copy to command output (forces text_mode and text_only).
 */

void copy_files (
    int err_flags,
    copy_opt_t *opt,
    const volume_t *vol,
    const fid_t *curwd,
    const char *src,
    const char *dest);

/*
 *  This routine returns non-zero if the record attributes indicate
 *  a possible text file.
 */

int maybe_text_file (const ods2_file_attr_t *recattr);

#endif /* COPY_H_LOADED */
