/*******************************************************************************
 *
 *  Copyright (c) 1999 by Thierry Lelegard
 *
 *  This software is covered by the "GNU GENERAL PUBLIC LICENSE" (GPL),
 *  version 2, June 1991. See the file named COPYING for details.
 *
 *  Project: VMSCD - OpenVMS CD-ROM Utility for Linux
 *  File:    list.h
 *  Author:  Thierry Lelegard
 *
 *
 *  Abstract
 *  --------
 *  This module implements the file listing ("ls") operations.
 *
 *
 *  Modification History
 *  --------------------
 *  26 Dec 1999 - Thierry Lelegard (lelegard@club-internet.fr)
 *                Creation of the file.
 *
 *
 *******************************************************************************
 */


#ifndef LIST_H_LOADED
#define LIST_H_LOADED 1

/*
 *  The following structure describes the list options.
 *  Binary zeroes are an acceptable default value.
 */

typedef struct {
    FILE *out;         /* Output file */
    int broken_out;    /* Boolean: output file is broken, stop here */
    int long_list;     /* Boolean: use long information */
    int list_all;      /* Boolean: list all files */
    int list_nodir;    /* Boolean: do not list directory content */
    int recurse;       /* Boolean: recurse into subdirectories */
    int list_fid;      /* Boolean: display FID values */
    int list_version;  /* Boolean: display version field in names */
    int width;         /* Display width (zero means unbounded) */
} list_opt_t;

/* 
 *  The following routine performs the list command.
 */

void list_files (
    int err_flags,
    list_opt_t *opt,
    const volume_t *vol,
    const fid_t *curwd,
    const char *path);

#endif /* LIST_H_LOADED */
