/*******************************************************************************
 *
 *  Copyright (c) 1999 by Thierry Lelegard
 *
 *  This software is covered by the "GNU GENERAL PUBLIC LICENSE" (GPL),
 *  version 2, June 1991. See the file named COPYING for details.
 *
 *  Project: VMSCD - OpenVMS CD-ROM Utility for Linux
 *  File:    utils.h
 *  Author:  Thierry Lelegard
 *
 *
 *  Abstract
 *  --------
 *  This module implements some low-level utility routines, not specific
 *  to vmscd.
 *
 *
 *  Modification History
 *  --------------------
 *  18 Dec 1999 - Thierry Lelegard (lelegard@club-internet.fr)
 *                Creation of the file.
 *
 *
 *******************************************************************************
 */


#ifndef UTILS_H_LOADED
#define UTILS_H_LOADED 1

/*
 *  This routine initialize the utils module.
 *  - Set the application name for further error messages.
 *  - Set debug flag for trace message.
 */

typedef enum {OFF = 0, ON = 1} onoff_t;

void init_utils (const char *argv0, onoff_t debug, int max_recall);

/*
 *  Get line routine. Return NULL at EOF, line otherwise.
 */

char *input (const char *prompt, char *line, int line_size);

/*
 *  Error message routine.
 *  May also print the current errno message.
 *  Always preserve errno.
 */

#define ERR_SILENT 0x0001
#define ERR_ERRNO  0x0002
#define ERR_EXIT   0x0004

void error (int err_flags, const char *format, ...);

/*
 *  Trace routine. Display only if boolean debug was set in init_utils
 */

void trace (const char *format, ...);

/*
 *  These routines return the size of a terminal.
 *  Return zero if the device is not a terminal.
 */

int terminal_rows (int fd);
int terminal_columns (int fd);

/*
 *  This routine dumps a memory area.
 *  The displayed addresses start at display_offset.
 */

void memdump (FILE *out, const void *data, int size, int display_offset);

/*
 *  Variant of malloc. Exit application in case of error.
 */

void *utmalloc (size_t size);

/*
 *  Mallocation of a copy of a string. Exit application in case of error.
 */

char *new_string (const char *s);

/*
 *  Check if a file exists and can be executed by the current process.
 */

int may_execute (const char *path);

/*
 *  Locate an executable file from $PATH.
 *  Return a mallocated string (or NULL if not found).
 */

char *find_exec (const char *name);

#endif /* UTILS_H_LOADED */
