// value with derivatives

// The "Value" is supposed to be a function of paramters t_1,...,t_n
// This structure stores the value of the "Value" and its n derivatives.


#define WANT_STREAM
#define WANT_MATH

#include "newmatio.h"
#include "vwd.h"


template <class T>
T test1(const T& Alpha, const T& Beta, const T& Gamma, const T& Delta)
{
   return
      exp( pow(cos(Alpha), 3) / 0.25) / exp(3 * cos(pow(Alpha, 1)))
         + Gamma * Gamma * exp( pow(cos(Beta), 2) )
         * pow( exp( sin(Beta) * sin(Beta) ), -1)
         * pow(Delta, 0) + sin(-Delta) * tan(Alpha);
}

template <class T>
T test2(const T& Alpha, const T& Beta, const T& Gamma, const T& Delta)
{
   T x = sin(-Delta);
   x *= sin(Alpha);
   x /= cos(Alpha);
   x += exp(cos(3 * Alpha)) + exp(cos(Beta * 2) + 2 * log(Gamma));
   return x;
}

template <class T>
T test3(const T& Alpha, const T& Beta, const T& Gamma, const T& Delta)
{
   T x = pow(Alpha, Beta);
   x = -x;
   x -= Gamma * pow(2.194463, Delta);
   x -= Alpha * pow(Gamma, 1.54892);
   x *= -2.5;
   x -= 2.3;
   return x;
}

template <class T>
T test4(const T& Alpha, const T& Beta, const T& Gamma, const T& Delta)
{
   return
      ( exp(log(Alpha) * Beta) + Gamma * exp(Delta * log(2.194463))
         + Alpha * exp(log(Gamma) * 1.54892) ) / 0.4 - 2.3;
}

template <class T>
T test5(const T& Alpha, const T& Beta, const T& Gamma, const T& Delta)
{
   T X = Alpha;
   X += 2.35;
   X -= Beta * pow(Gamma, 2);
   X *= 1.0 / Delta;
   X /= 1.45612;
   X -= 1.289;
   X /= Alpha + Beta;
   X *= 0.8901;
   return X;
}

template <class T>
T test6(const T& Alpha, const T& Beta, const T& Gamma, const T& Delta)
{
   return
      ((Alpha + 2.35 - Beta * Gamma * Gamma) / (Delta * 1.45612) - 1.289)
         / (Alpha + Beta) * 0.8901;
}


template <class T>
T test7(const T& Alpha, const T& Beta, const T& Gamma, const T& Delta)
{
   T X = 3.33 + pow(Alpha,3);
   T Y = 2.09 * pow(Beta,3);
   T Z = 1.89 / pow(Gamma,2);
   T U = 7.83 - pow(Delta,3);
   return X * Y * Z * U;

}


template <class T>
T test8(const T& Alpha, const T& Beta, const T& Gamma, const T& Delta)
{
   T Alpha3 = Alpha * Alpha * Alpha;
   T Beta3 = Beta * Beta * Beta;
   T Gamma2 = Gamma * Gamma;
   T Delta3 = Delta * Delta * Delta;
   return
      -(Alpha3 + 3.33) * (Beta3 * 2.09) * 1.89 * (Delta3 - 7.83) / Gamma2;
}




main()
{
   // test ParameterSet
   Try
   {
      ParameterSet PS, PS2;
      cout << "Add P1 " << PS.AddParameter("P1") << endl;
      cout << "Add P2 " << PS.AddParameter("P2") << endl;
      cout << "Add P3 " << PS.AddParameter("P3") << endl;
      cout << "locate P3 " << PS.LocateParameter("P3") << endl;
      cout << "locate P4 " << PS.LocateParameter("P4") << endl;
      cout << "locate P2 " << PS.LocateParameter("P2") << endl;
      AssertEqual(PS, PS);
      cout << "number of parameters = " << PS.Size() << endl;
      cout << "Add P4 " << PS.AddParameter("P4") << endl;
      cout << "Add P5 " << PS.AddParameter("P5") << endl;
      cout << "Name 4 = " << PS(4) << endl;
      cout << "Name 2 = " << PS(2) << endl;
      cout << "Name 2 = " << PS(2) << endl;
      cout << "Name 3 = " << PS(3) << endl;
      cout << "Name 1 = " << PS(1) << endl;
      cout << "Name 5 = " << PS(5) << endl;
      cout << "locate P3 " << PS.LocateParameter("P3") << endl;
      cout << "locate P4 " << PS.LocateParameter("P4") << endl;
      cout << "locate P2 " << PS.LocateParameter("P2") << endl;
      cout << "number of parameters = " << PS.Size() << endl;
      AssertEqual(PS, PS2);
      cout << "finishing test" << endl;
   }
   Catch(Logic_error) { cout << Exception::what() << endl; }
   CatchAndThrow;

   // test the automatic differentiation
   Try
   {
      ParameterSet PS;
      PS.AddParameter("alpha");
      PS.AddParameter("beta");
      PS.AddParameter("gamma");
      PS.AddParameter("delta");

      Real alpha = 1.237;
      Real beta = 0.973;
      Real gamma = 3.562;
      Real delta = 2.673;

      ValueWithDerivatives Alpha1(PS, alpha, "alpha");
      ValueWithDerivatives Beta1(PS, beta, "beta");
      ValueWithDerivatives Gamma1(PS, gamma, "gamma");
      ValueWithDerivatives Delta1(PS, delta, "delta");

      ValueWithDerivatives2 Alpha2(PS, alpha, "alpha");
      ValueWithDerivatives2 Beta2(PS, beta, "beta");
      ValueWithDerivatives2 Gamma2(PS, gamma, "gamma");
      ValueWithDerivatives2 Delta2(PS, delta, "delta");

      Real x; ValueWithDerivatives X1(PS); ValueWithDerivatives2 X2(PS);

      cout << "Doing test1" << endl;
      x = test1(alpha, beta, gamma, delta);
      X1 = test1(Alpha1, Beta1, Gamma1, Delta1);
      X2 = test1(Alpha2, Beta2, Gamma2, Delta2);
      cout << setw(17) << setprecision(10) << x << endl;
      cout << setw(17) << setprecision(10) << X1.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X1.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X2.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetSecondDerivatives() << endl;
      cout << endl;

      cout << "Doing test2" << endl;
      x = test2(alpha, beta, gamma, delta);
      X1 = test2(Alpha1, Beta1, Gamma1, Delta1);
      X2 = test2(Alpha2, Beta2, Gamma2, Delta2);
      cout << setw(17) << setprecision(10) << x << endl;
      cout << setw(17) << setprecision(10) << X1.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X1.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X2.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetSecondDerivatives() << endl;
      cout << endl;

      cout << "Doing test3" << endl;
      x = test3(alpha, beta, gamma, delta);
      X1 = test3(Alpha1, Beta1, Gamma1, Delta1);
      X2 = test3(Alpha2, Beta2, Gamma2, Delta2);
      cout << setw(17) << setprecision(10) << x << endl;
      cout << setw(17) << setprecision(10) << X1.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X1.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X2.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetSecondDerivatives() << endl;
      cout << endl;

      cout << "Doing test4" << endl;
      x = test4(alpha, beta, gamma, delta);
      X1 = test4(Alpha1, Beta1, Gamma1, Delta1);
      X2 = test4(Alpha2, Beta2, Gamma2, Delta2);
      cout << setw(17) << setprecision(10) << x << endl;
      cout << setw(17) << setprecision(10) << X1.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X1.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X2.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetSecondDerivatives() << endl;
      cout << endl;

      cout << "Doing test5" << endl;
      x = test5(alpha, beta, gamma, delta);
      X1 = test5(Alpha1, Beta1, Gamma1, Delta1);
      X2 = test5(Alpha2, Beta2, Gamma2, Delta2);
      cout << setw(17) << setprecision(10) << x << endl;
      cout << setw(17) << setprecision(10) << X1.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X1.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X2.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetSecondDerivatives() << endl;
      cout << endl;

      cout << "Doing test6" << endl;
      x = test6(alpha, beta, gamma, delta);
      X1 = test6(Alpha1, Beta1, Gamma1, Delta1);
      X2 = test6(Alpha2, Beta2, Gamma2, Delta2);
      cout << setw(17) << setprecision(10) << x << endl;
      cout << setw(17) << setprecision(10) << X1.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X1.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X2.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetSecondDerivatives() << endl;
      cout << endl;

      cout << "Doing test7" << endl;
      x = test7(alpha, beta, gamma, delta);
      X1 = test7(Alpha1, Beta1, Gamma1, Delta1);
      X2 = test7(Alpha2, Beta2, Gamma2, Delta2);
      cout << setw(17) << setprecision(10) << x << endl;
      cout << setw(17) << setprecision(10) << X1.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X1.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X2.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetSecondDerivatives() << endl;
      cout << endl;

      cout << "Doing test8" << endl;
      x = test8(alpha, beta, gamma, delta);
      X1 = test8(Alpha1, Beta1, Gamma1, Delta1);
      X2 = test8(Alpha2, Beta2, Gamma2, Delta2);
      cout << setw(17) << setprecision(10) << x << endl;
      cout << setw(17) << setprecision(10) << X1.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X1.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetValue() << endl;
      cout << setw(17) << setprecision(10) << X2.GetDerivatives() << endl;
      cout << setw(17) << setprecision(10) << X2.GetSecondDerivatives() << endl;
      cout << endl;


   }
   CatchAll { cout << Exception::what() << endl; }


   return 0;
}
