#include "../lib/mcrypt.h"
#include <stdio.h>
#include <stdlib.h>

/* Prints plaintext and ciphertext in hex for all the algorithms */

#define ALGORITHMS_DIR "../modules/algorithms/.libs"
#define MODES_DIR NULL
 
int main()
{
	char *name;
	int td;
	int i, imax;
	int j, jmax;
	int x = 0;
	char **names;
	char **modes;

	names = mcrypt_list_algorithms (ALGORITHMS_DIR, &jmax);
	modes = mcrypt_list_modes (MODES_DIR, &imax);
	
	for (j=0;j<jmax;j++) {
		printf( "Algorithm: %s... ", names[j]);
		if (mcrypt_module_self_test( names[j], ALGORITHMS_DIR)==0) {
			printf( "ok\n\tworks in: "); 
		} else {
			x=1;
		}

		for (i=0;i<imax;i++) {
		

			td = mcrypt_module_open(names[j], ALGORITHMS_DIR, modes[i], MODES_DIR);
			if (td>=0) {
				printf( "%s ", modes[i]);
				mcrypt_module_close(td);
			}
		}
		printf("\n");
	}	
	
		
	return x;
}
