$! ADD_ITEM.COM
$! 27-JUN-1997, David Mathog, Biology Division, Caltech
$!  modified from David Jones' DCL_ENV_RM.COM
$!
$! This accepts a request for a new auction.  It grabs the next available
$! number, increments the counter.  Then it creates the auction files.
$!
$ ITEMCOUNT := [.AUCTION]ITEMCOUNT.DAT
$ ALLBIDS   := [.AUCTION]ALLBIDS
$ FORSALE   := [.AUCTION]FORSALE
$ MAXBID    := [.AUCTION]MAXBID
$!
$!
$ write net_link "<DNETRECMODE>"	! Set implied carriage control.
$!
$ mcr 'f$parse("SET_DCL_ENV.EXE;",f$environment("PROCEDURE")) "WWW_"
$! CGI_SYMBOLS "WWW_" "FORM_"
$!
$! Send back CGI response.  Note that newlines (<CR><LF>) must be
$! explicitly sent.
$!
$ set noon
$ set nover
$ put = "write net_link"
$ put "content-type: text/plain"
$ put "status: 200 (meaningless)"
$ put "extra-header: (meaningless)"
$ if www_request_method .eqs. "HEAD" then exit
$!
$ create net_link:

$ define sys$output net_link:
$!
$!
$! extract the specified data from the form_fld_ variables
$!
$ allin = WWW_KEY_COUNT
$!
$! extract all fields except the user information
$!
$ icount = 0
$ top:
$    icount = icount + 1
$    variable = www_key_'icount'
$    if(variable .nes. "records")
$    then 
$      icount = icount + 1
$      value = www_key_'icount'
$      if(variable .eqs. "NAME")
$      then
$         if((value .eqs. "") .or. -
             (f$locate(":",value) .nes. f$length(value)))then goto byebye2
$         inname = value
$      endif
$      if(variable .eqs. "NAMESUBMITTER")
$      then
$         if((value .eqs. "") .or. -
             (f$locate(":",value) .nes. f$length(value)))then goto byebye2
$         innamesubmitter = value
$      endif
$      if(variable .eqs. "SUBMITTER")
$      then
$         if((value .eqs. "") .or. -
             (f$locate(":",value) .nes. f$length(value)))then goto byebye2
$         insubmitter = value
$      endif
$      if(variable .eqs. "KEY")
$      then
$         if((value .eqs. "") .or. -
             (f$locate(":",value) .nes. f$length(value)))then goto byebye2
$         inkey = value
$      endif
$      if(variable .eqs. "MINBID")
$      then
$         if(f$type(value) .nes. "INTEGER" .or. value .lt. 0)then goto byebye2
$         inminbid = value
$      endif
$      if(icount .le. allin)then goto top
$    else
$!
$! Handle 0, 1, or multiple lines of additional information
$!
$      icount = icount + 1
$      is_o = f$type(www_key_'icount')
$      is_c = f$type(www_key_'icount'_count)
$      is_1 = f$type(www_key_'icount'_1)
$      if(is_o .eqs. "" .and. is_1 .eqs. "")then goto byebye2
$! if only one record entered, fake the symbols
$! we actually write them out later
$!
$      if (is_c .nes. "")
$      then 
$        numrecs = www_key_'icount'_count
$      else
$        numrecs = 1
$        www_key_'icount'_1 = www_key_'icount'
$      endif
$      variable = "www_key_''icount'"
$    endif
$!
$ indate      = F$TIME()
$!
$! now try to grab the counter file.  If we can't, then wait a while,
$! and try again.  Otherwise, increment the counter and reset it.
$! limit the time in this loop to three seconds, fail if we cannot get
$! itemcount within that time
$!
$ maxwaits = 30
$ loopout1:
$    open/read/write/error=pause1 infil: 'itemcount'
$    read infil: string
$    count = f$integer(string)
$    count = count + 1
$    string = "00000000000000"+f$string(count)
$    slen = f$length(string)
$    string = f$extract(slen-10,10,string)
$    write/update infil: string
$    close infil:
$    goto makefiles
$ pause1:
$    wait 00:00:00.10
$    maxwaits = maxwaits - 1
$    if( maxwaits .gt. 0)then goto loopout1
$    goto byebye3
$!
$ makefiles:
$!
$! first the bids file
$!
$ openit = allbids + f$string(count) + ".dat"
$ open/write/error=byebye3 ofil: 'openit'
$ outstring = "NUMBER," + f$string(count) + -
              ",BIDVAL," + f$string(inminbid) + -
              ",DATE," + indate + -
              ",BIDDER," + insubmitter + -
              ",NAME," + innamesubmitter + "(SELLER)"
$ write ofil: outstring
$ close ofil:
$!
$! then the MAXBID file
$!
$ openit = maxbid + f$string(count) + ".dat"
$ open/write/error=byebye3 ofil: 'openit'
$ string = "00000000000000"+f$string(inminbid)
$ slen = f$length(string)
$ outstring = f$extract(slen-10,10,string)
$ write ofil: outstring
$ close ofil:
$!
$! now the description file
$!
$ openit = forsale + f$string(count) + ".dat"
$ open/write/error=byebye3 ofil: 'openit'
$ outstring = "NAME:" + inname + -
              ":KEY:" + inkey + -
              ":SUBMITTER:" + insubmitter + -
              ":SELLER:" + innamesubmitter
$ write ofil: outstring
$!
$! now any description records are written out too
$!
$ jcount = 1
$ loopout2:
$    write ofil: 'variable'_'jcount'
$    jcount = jcount + 2
$    if(jcount .le. numrecs)then goto loopout2
$!
$ close ofil:
$!
$!
$ write sys$output "Item accepted for auction"
$ goto byebye
$!
$ byebye3:
$   write sys$output "Error:"
$   write sys$output "  Fatal server error, could not create auction files"
$   write sys$output "  Please report error to administrator"
$   goto byebye
$!
$ byebye2:
$   write sys$output "One of the following errors was detected:"
$   write sys$output "  Not all fields were filled in."
$   write sys$output "  There was a "":"" in one of the first 4 fields."
$   write sys$output "  The minimum bid was less than zero dollars."
$   write sys$output "Submission rejected."
$   goto byebye
$!
$ byebye:
$ deass sys$output
$ exit
