$! DELETE_ITEM.COM
$! 28-JUN-1997, David Mathog, Biology Division, Caltech
$!  modified from David Jones' DCL_ENV_RM.COM
$!
$! This accepts a request from the seller (identified by their email 
$! address and their unique KEY) to cancel a sale.  All bidders are
$! notified, provided with the final sale price, and the auction files
$! are removed.
$!
$ RESULTS   :=  [.AUCTION]RESULTS.DAT
$ ALLBIDS   :=  [.AUCTION]ALLBIDS
$ MAXBID    :=  [.AUCTION]MAXBID
$ FORSALE    = "[.AUCTION]FORSALE*.DAT"
$!
$!
$ write net_link "<DNETRECMODE>"	! Set implied carriage control.
$!
$ mcr 'f$parse("SET_DCL_ENV.EXE;",f$environment("PROCEDURE")) "WWW_"
$! CGI_SYMBOLS "WWW_" "FORM_"
$!
$! Send back CGI response.  Note that newlines (<CR><LF>) must be
$! explicitly sent.
$!
$ set noon
$ set nover
$ put = "write net_link"
$ put "content-type: text/html"
$ put "status: 200 (meaningless)"
$ put "extra-header: (meaningless)"
$ if www_request_method .eqs. "HEAD" then exit
$!
$ create net_link:

$ define sys$output net_link:
$!
$!
$! extract the specified data from the form_fld_ variables
$!
$ allin = WWW_KEY_COUNT - 2
$!
$! extract all fields except the user information
$!
$ icount = 0
$ top:
$    icount = icount + 1
$    variable = www_key_'icount'
$      icount = icount + 1
$      value = www_key_'icount'
$      if(variable .eqs. "SUBMITTER")
$      then
$         if((value .eqs. "") .or. -
             (f$locate(":",value) .nes. f$length(value)))then goto byebye1
$         insubmitter = f$edit(value,"UPCASE")
$      endif
$      if(variable .eqs. "KEY")
$      then
$         if((value .eqs. "") .or. -
             (f$locate(":",value) .nes. f$length(value)))then goto byebye1
$         inkey = f$edit(value,"UPCASE")
$      endif
$      if(icount .le. allin)then goto top
$!
$ indate      = F$TIME()
$!
$! now figure out which sale this is from the key and submitter
$! info.
$!
$ loop0:
$   file=f$search(forsale)
$   if(file .nes. "")
$   then
$      open/share=read/error=byebye3 ifil: 'file'
$      read/error=byebye2/end=byebye2 ifil: string
$      close ifil:
$      string = f$edit(string,"UPCASE")
$      if( (f$element(3,":",string) .eqs. inkey)  .and. -
           (f$element(5,":",string) .eqs. insubmitter) )
$      then
$         sale = f$parse(file,,,"NAME") - "FORSALE"
$         descrip = f$element(1,":",string)
$         goto thissale
$      endif
$   else
$      write sys$output "Sorry, that email address and key do not correspond to"
$      write sys$output "any current auction items."
$      goto byebye
$   endif
$   goto loop0
$!
$ thissale:
$!
$! first, grab and lock the maxbid file
$!
$ file = maxbid + f$string(sale) + ".dat"
$ open/write/read/error=byebye3 lfil: 'file'
$ read/error=byebye1/end=byebye1 lfil: string
$ soldat = f$integer(string)
$!
$! second scan the bids file for email addresses, and make a list
$!
$ notifylist="a"
$ bidders = -1
$ bids = -1
$ file = allbids + f$string(sale) + ".dat"
$ open/share=read/error=byebye3 ifil: 'file'
$ loopout1:
$   read/end=doneout/error=doneout ifil: string
$   inemail = f$element(7,",",string)
$   bids = bids + 1
$   if(f$locate(inemail,notifylist) .eqs. f$length(notifylist))
$   then
$      notifylist = notifylist + ":" + inemail
$      bidders = bidders + 1
$   endif
$   goto loopout1
$!
$ doneout:
$ close ifil:
$!
$!
$! compose an email message
$!
$ time = f$time()
$ name = "KILL_" + -
      f$cvtime(time,,"hour") + -
      f$cvtime(time,,"minute") + -
      f$cvtime(time,,"second") +  -
      f$cvtime(time,,"hundredth") + -
      ".txt"
$ open/write ofil: 'name'
$ write ofil: "The auction of item number ''sale'"
$ write ofil: ""
$ write ofil: "    ''descrip'"
$ write ofil: ""
$ write ofil: "completed at ''time'."
$ write ofil: ""
$ write ofil: "The winning bid for this item was $''soldat'."
$ write ofil: "There were ''bidders' bidders."
$ write ofil: "There were ''bids' bids."
$ write ofil: ""
$ write ofil: "Thank you for bidding, and please visit the Biology Division"
$ write ofil: "auction again."
$ close ofil:
$!
$! send the message to all bidders
$!
$ icount = 1
$ loopmail:
$   address = f$element(icount,":",notifylist)
$   if(address .eqs. ":")then goto cleanup
$   mail/subject="auction closed: ''descrip'" 'name' smtp%"""''address'"""
$   icount = icount + 1
$   goto loopmail
$!
$! add this sale to the permanent record
$!
$ cleanup:
$ delete 'name';
$ write sys$output "All bidders have been notified.<BR>"
$ open/append/error=byebye3 ofil: 'results'
$ outstring = "ITEM:''descrip':DATE:''time':BIDDERS:''bidders':BIDS:''bids':PRICE:''soldat'"
$ write ofil: outstring
$ close ofil:
$!
$! remove relevant auction files
$!
$ tname = allbids + f$string(sale) + ".DAT;*"
$ delete 'tname'
$ tname = forsale - "*.DAT" + f$string(sale) + ".DAT;*"
$ delete 'tname'
$! lastly, the lock file = maxbid file
$ tname = maxbid + f$string(sale) + ".DAT;*"
$ close lfil:
$ delete 'tname'
$!
$ write sys$output "Item successfully removed from auction.<BR>"
$ goto byebye
$!
$ byebye1:
$   write sys$output "Error:<BR>"
$   write sys$output "  One or more fields are empty.<BR>"
$   write sys$output "  One or more fields contains a "":"" .<BR>"
$   goto byebye
$ byebye2:
$   close ifil:
$ byebye3:
$   write sys$output "Error:<BR>"
$   write sys$output "  Fatal server error.<BR>"
$   write sys$output "  Problem: ''file' is corrupted.<BR>"
$   write sys$output "  Please report this error to the administrator.<BR>"
$   goto byebye
$!
$ byebye:
$ close/nolog lfil:
$ deass sys$output
$ exit
