$! SELL_ITEM.COM
$!  modified from David Jones' DCL_ENV_RM.COM
$!
$! This routine can be used to accept auction bids on a specific piece of
$! equipment.
$!
$ ALLBIDS  := [.AUCTION]ALLBIDS
$ MAXBID   := [.AUCTION]MAXBID
$!
$! ALLBIDS records are of the form:
$! NUMBER:            (of the item)
$! DATE:              (of the bid)
$! BIDVAL:            (in dollars, like 100.23)
$! BIDDER:            (bidder's email address)
$! NAME:              (bidder's full name)
$!
$! MAXBID holds the current maximum bid.  Before a new bid can be 
$! accepted we lock this file, check its contents, commit the bid,
$! update the value, and then release.  That prevents simultaneous bids
$! from crossing paths (ie two people sit 5 minutes, then each bids)
$! If a race is detected, and one bidder is now less than the maximum,
$! their bid is rejected.
$!
$ write net_link "<DNETRECMODE>"	! Set implied carriage control.
$!
$ mcr 'f$parse("SET_DCL_ENV.EXE;",f$environment("PROCEDURE")) "WWW_"
$! CGI_SYMBOLS "WWW_" "FORM_"
$!
$! Send back CGI response.  Note that newlines (<CR><LF>) must be
$! explicitly sent.
$!
$ set noon
$ set nover
$ put = "write net_link"
$ put "content-type: text/html"
$ put "status: 200 (meaningless)"
$ put "extra-header: (meaningless)"
$ if www_request_method .eqs. "HEAD" then exit
$!
$ create net_link:

$ define sys$output net_link:
$!
$ write sys$Output "<HTML>"
$ write sys$Output "<HEAD>"
$ write sys$Output "<title>biology division auction system: ENTER_BID module</title>"
$ write sys$Output "</HEAD>"
$ write sys$Output "<BODY>"
$!
$!
$! extract the specified data from the form_fld_ variables
$!
$ allin = WWW_KEY_COUNT - 2
$!
$! extract all fields except the user information
$!
$ icount = 0
$ top:
$   icount = icount + 1
$   variable = www_key_'icount'
$   icount = icount + 1
$   value = www_key_'icount'
$   'variable' = value
$   if(variable .eqs. "NUMBER")then innumber = value
$   if(variable .eqs. "BIDVAL")then inbadval = value
$   if(variable .eqs. "NAME")then inname = value
$   if(variable .eqs. "BIDDER")then inbidder = value
$   if(icount .le. allin)then goto top
$!
$ indate      = F$TIME()
$!
$! verify that there is a name and email address
$!
$ if( (f$length(inname) .eqs. 0) .or. (f$length(inbidder) .eqs. 0) )
$ then
$   write sys$output "Sorry, you must fill in both your name and email address."
$   write sys$output "Your bid cannot be accepted without this information."
$   goto byebye
$ endif
$!
$! lock the maxbids file, verify that the current bid is still valid
$! if we can't get it in 3 seconds, then fail
$!
$ maxwaits = 30
$ openit = maxbid + innumber + ".DAT"
$ loopout0:
$    open/read/write/error=pause0 mfil: 'openit'
$    read mfil: maxbid
$    inmaxbid = f$integer(maxbid)
$    if(inmaxbid .gt. bidval)
$    then
$        write sys$Output "Sorry, while you were thinking somebody else raised"
$        write sys$Output "the maximum bid to ''inmaxbid'.  Your bid cannot"
$        write sys$output "be accepted as it is less than the current maximum."
$        close mfil:
$        goto byebye
$    else
$        goto bidok
$    endif
$ pause0:
$    wait 00:00:00.10
$    maxwaits = maxwaits - 1
$    if (maxwaits .gt. 0)then goto loopout0
$    write sys$Output "Sorry, some sort of server error - could not get'
$    write sys$Output "access to the maximum bids file.  Please report this'
$    write sys$output "error to the administrator.'
$    goto byebye
$!
$! notify the last bidder that they have been outbid
$! write it out
$!
$ bidok:
$ maxwaits = 30
$ openit = allbids + innumber + ".DAT"
$ loopout1:
$    open/read/write/error=pause1 ofil: 'openit'
$ scanout1:
$    read/end=donescan/error=donescan ofil: string
$    goto scanout1
$ donescan:
$! email address of last highest bidder
$ address = f$element(7,",",string)
$!
$! now close it.
$!
$    outstring = "NUMBER," + innumber + -
                 ",BIDVAL," + bidval + -
                 ",DATE," + indate + -
                 ",BIDDER," + inbidder + -
                 ",NAME," + inname
$    write ofil: outstring
$    close ofil:
$!
$!   Update, then unlock the maxbid file
$!
$    string = "00000000000000"+f$string(bidval)
$    slen = f$length(string)
$    string = f$extract(slen-10,10,string)
$    write/update mfil: string
$    close mfil:
$!
$! notify by email
$!
$   mail/subject="auction item ''innumber' - new highest bid = ''bidval'" -
    SYS$INPUT smtp%"""''address'"""
This is an automatically generated message.  

Another bidder has just bid more than you for this auction item.

You may bid again if you so desire.
$!
$    goto dobyebye
$ pause1:
$    wait 00:00:00.10
$    maxwaits = maxwaits - 1
$    if (maxwaits .gt. 0)then goto loopout1
$    close/nolog mfil:
$    write sys$Output "Sorry, some sort of server error - could not get'
$    write sys$Output "access to the bids file.  Please report this'
$    write sys$output "error to the administrator.'
$    goto byebye
$!
$!  now fix the summary
$!
$ dobyebye:
$!
$ write sys$output "Thank you for your bid of $''bidval'"
$!
$ byebye:
$ write sys$output "<P>"
$ write sys$output "<A href=""/www/sell_item.html"">Return to auction main page</A>"
$ write sys$output "<P>"
$ write sys$output "<A href=""/htbin/display_item"">Bid on another item</A>"
$ write sys$output "<P>"
$ write sys$Output "</BODY>"
$ write sys$Output "</HTML>"
$ deass sys$output
$ exit
