/* <ctype.h>
 *
 *	VAXCRTL compatible character manipulation.
 */
/*
** 20-Dec-1998	J. Malmberg	Added some wide character support
**
** 23-Dec-1998	J. Malmberg	Added prototypes required by X/OPEN
**
** 28-Dec-1998	J. Malmberg	Per ANSI Working Draft, 1997-11-21,
**				WG14/N794 J11/97-158:
**				Added isblank()
*/
#ifndef _CTYPE_H
#define _CTYPE_H
# ifdef __cplusplus
extern "C" {
# endif

extern __const char _ctype_[];
/*
 *	The following bit of ugliness is to ensure that the _ctype_[]
 *	initialization is brought in from the VAXCRTL library.
 */
extern int __ctypes__ __asm("_$$PsectAttributes_GLOBALSYMBOL$$c$v_ctypedefs");

extern const int * __ctype __asm("decc$$ga___ctypet");
extern int __ctypea __asm("decc$gl___ctypea");

/* internal macros */
#define _U	(0001)
#define _L	(0002)
#define _N	(0004)
#define _S	(0010)
#define _P	(0020)
#define _C	(0040)
#define _X	(0100)
#define _B	(0200)

int toupper(int), tolower(int);   /* these are in VAXCRTL & required by ANSI */
int _toupper(int), _tolower(int); /* these are in GCCLIB, but redefined below */

/*
 *	ctype macros:  Note we need to strip the character to 7-bit ASCII.
 *	The results are not accurate for 8-bit data, but are at least safe.
 */
#define isalnum(c)	(_ctype_[(c)&0177] & (_U|_L|_N))
#define isalpha(c)	(_ctype_[(c)&0177] & (_U|_L))
#define isascii(c)	((unsigned char)(c) <= 0177)
#define isblank(c)	(_ctype_[(c)&0177] & _B)
#define iscntrl(c)	(_ctype_[(c)&0177] & _C)
#define isdigit(c)	(_ctype_[(c)&0177] & _N)
#define isgraph(c)	(_ctype_[(c)&0177] & (_P|_U|_L|_N))
#define islower(c)	(_ctype_[(c)&0177] & _L)
#define isprint(c)	(_ctype_[(c)&0177] & (_P|_U|_L|_N|_B))
#define ispunct(c)	(_ctype_[(c)&0177] & _P)
#define isspace(c)	(_ctype_[(c)&0177] & _S)
#define isupper(c)	(_ctype_[(c)&0177] & _U)
#define isxdigit(c)	(_ctype_[(c)&0177] & (_N|_X))


#define toascii(c)	((c) & 0177)
#define _toupper(c)	((c) & ~040)
#define _tolower(c)	((c) |	040)
/* the above 2 macros only give reliable results when passed an ASCII letter */

/* X/Open also requires function prototypes  */
int (isalnum)(int __c);
int (isalpha)(int __c);
int (isascii)(int __c);
int (isblank)(int __c);		/* Not in DEC C RTL */
int (iscntrl)(int __c);
int (isdigit)(int __c);
int (isgraph)(int __c);
int (islower)(int __c);
int (isprint)(int __c);
int (ispunct)(int __c);
int (isspace)(int __c);
int (isupper)(int __c);
int (isxdigit)(int __c);
int (toascii)(int __c);

# ifdef __cplusplus
}
# endif
#endif	/*_CTYPE_H*/
