/* <fcntl.h>
 *
 *	Constants for Unix-style I/O routines.
 */
/* 05-Jul-1998	J. Malmberg	Added some missing definitions */
/* 20-Oct-1998	J. Malmberg	Moved to X/OPEN specified directory */
/* 03-Dec-1998	J. Malmberg	Found some things referenced by SocketSHR */
/* 23-Dec-1998	J. Malmberg	Updated to X/OPEN and ANSI */

#ifndef _FCNTL_H
#define _FCNTL_H

#ifndef _SYS_FCNTL_H
#define _SYS_FCNTL_H
#endif			/* see also <file.h> */

#include <sys/types.h>

#define O_RDONLY	(0)		/* Open for reading only. */
#define O_WRONLY	(1)		/* Open for writing only. */
#define O_RDWR		(2)		/* Open for reading and writing. */
#define O_NDELAY	(4)
#define O_NOWAIT	(4)
#define O_APPEND	(8)		/* Set append mode */
#define O_CREAT		(0x0200)	/* Create file if it does not exist */
#define O_TRUNC		(0x0400)	/* Truncate flag */
#define O_EXCL		(0x0800)	/* Exclusive use flag */


/* these aren't implemented in VAXCRTL, so are useless */
#define O_BLKINUSE	(0x1000)
#define O_BLKANDSET    (0x2000|O_BLKINUSE)
#define O_DSYNC		(0x4000)	/* Write according to synchronized */
					/*   I/O data integrity completion */
					/*   From POSIX may not exist */
#define O_SYNC		(0x8000)		/* Write according to synchronized */
					/*   I/O file integrity completion */
#define O_FSYNC		(0x8000)

#define O_NONBLOCK	(0x020000)	/* Non-Blocking mode */
#define O_NOCTTY	(0x080000)	/* Do not assign controlling terminal */
#define O_TERMIO	(0x040000)

/*	O_RSYNC		??? */		/* Synchronized read I/O operations */

/* Mask for file access modes. */
#define O_ACCMODE	(O_RDONLY | O_WRONLY | O_RDWR)

/* values used by access() routine, which should be avoided */
#define F_OK	(0)	/* test whether file exists */
#define X_OK	(1)	/* test execute access */
#define W_OK	(2)	/* test write access */
#define R_OK	(4)	/* test read access */

/* values useable by lseek(); SEEK_xxx values in <stdio.h> are preferred */
#define L_SET	(0)	/* absolute offset; ie, from beginning of file */
#define L_INCR	(1)	/* incremental offset; ie, relative to current pos */
#define L_XTND	(2)	/* extend offset; ie, relative to end-of-file */


  /* Neither DECC RTL or VAXC RTL can be relied to supply */
 /*  the fcntl() function.				 */
/*------------------------------------------------------*/
typedef struct flock {
   short l_type;	/* type of lock; F_RDLCK, F_WRLCK, F_UNLCK */
   short l_whence;	/* flag for starting offset */
   off_t l_start;	/* relative offset in bytes */
   off_t l_len;		/* size; if 0 then until EOF */
   pid_t l_pid;		/* process ID of the process holding the lock; */
			/*  return with F_GETLK */
} flock_t;


 /* cmd values for probably non-existant fcntl() */
/*----------------------------------------------*/
#define F_DUPFD		(0)	/* Duplicate file descriptor */
#define F_GETFD		(1)	/* Get file descriptor flags */
#define F_SETFD 	(2)	/* Set file descriptor flags */
#define F_GETFL		(3)	/* Get file status flags and file access modes*/
#define F_SETFL 	(4)	/* Set file status flags */
#define F_GETLK		(7)	/* Get record locking information */
#define F_SETLK 	(8)	/* Set record locking information */
#define F_SETLKW	(9)	/* Set record locking information; */
				/*   wait if blocked */

 /* Locking values */
/*----------------*/
#define F_RDLCK	(01)	/* Shared or read lock */
#define F_WRLCK (02)	/* Exclusive or write lock */
#define F_UNLCK (03)	/* Unlock */

 /* Older C locking values, used by SOCKETSHR */
/*-------------------------------------------*/
#ifndef FREAD
#define FREAD F_RDLCK
#endif
#ifndef FWRITE
#define FWRITE F_WRLCK
#endif
#ifndef FSHLOCK
#define FSHLOCK (00200)		/* shared lock present */
#endif
#ifndef FEXLOCK
#define FEXLOCK (00400)		/* exclusive lock present */
#endif

#define FD_CLOEXEC (1)	/* Close the file descriptor upon execution */
			/* of an exec family function */

#ifndef SEEK_SET
#define SEEK_SET (0)
#endif
#ifndef SEEK_CUR
#define SEEK_CUR (1)
#endif
#ifndef SEEK_END
#define SEEK_END (2)
#endif

# ifdef __cplusplus
extern "C" {
# endif

int fcntl(int, int, ...);
int creat(const char *, mode_t, ...);
int open(const char *, int, ...);

# ifdef __cplusplus
}
#endif

#endif	/*_FCNTL_H*/
