/* <malloc.h>
 *
 *	Unix-compatability memory allocator header; use ANSI <stdlib.h> instead.
 *
 * 29-Dec-1998	J. Malmberg	Changed sbrk() according to X/OPEN
 *				and DEC C RTL
 *
 */
#ifndef _MALLOC_H
#define _MALLOC_H
# ifdef __cplusplus
extern "C" {
# endif

 /* Need to get intptr_t typedef */
#include <inttypes.h>

#ifdef __STDC__
 /* 'unsigned's should actually be 'size_t' */
void	*malloc(unsigned);
void	*calloc(unsigned, unsigned);
void	*realloc(void *, unsigned);
void	 free(void *);
void	 cfree(void *);
int	 brk(void *);			/* also in our <unixlib.h> */
#if 0
void	*sbrk(unsigned long);		/*  ditto  */
#else
void	*sbrk(intptr_t);	/* X/OPEN */
#endif
#else
char	*malloc(), *calloc(), *realloc();
void	 free(), cfree();
int	 brk();
char	*sbrk();
#endif

# ifdef __cplusplus
}
# endif
#endif	/*_MALLOC_H*/
