 /* FILE: NETDB.H **J  * Copyright (c) 1980, 1983, 1988 Regents of the University of California.  * All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *%  *	@(#)netdb.h	5.15 (Berkeley) 4/3/91   *C ** 25-Jun-1998	J. Malmberg	For VMS GCC and SOCKETSHR compatability.  **M ****************************************************************************/   4 #if (!defined(_NETDB_H) && !defined(__NETDB_LOADED)) #ifndef _NETDB_H #define _NETDB_H #endif #ifndef __NETDB_LOADED #define __NETDB_LOADED #endif   #include <inttypes.h>  #include <sys/types.h>   #if 0  #include <paths.h>2 #define _PATH_HEQUIV	__PATH_ETC_INET"/hosts.equiv"+ #define _PATH_HOSTS	__PATH_ETC_INET"/hosts" 1 #define _PATH_NETWORKS	__PATH_ETC_INET"/networks" 3 #define _PATH_PROTOCOLS	__PATH_ETC_INET"/protocols" 1 #define _PATH_SERVICES	__PATH_ETC_INET"/services" 3 #define _PATH_RESCONF	__PATH_ETC_INET"/resolv.conf" ' #define _PATH_RPC	__PATH_ETC_INET"/rpc"  #endif   # ifdef __cplusplus  extern "C" { # endif    /*G  * Structures returned by network data base library.  All addresses are F  * supplied in host order, and returned in network order (suitable for  * use in system calls).  */    struct	hostent {* 	char	*h_name;	/* official name of host */$ 	char	**h_aliases;		/* alias list */) 	int	h_addrtype;		/* host address type */ ' 	int	h_length;		/* length of address */ > 	char	**h_addr_list;		/* list of addresses from name server */G #define	h_addr	h_addr_list[0]		/* address, for backward compatiblity */  	};    /*+  * Assumption here is that a network number *  * fits in 32 bits -- probably a poor one.  */    struct	netent { * 	char		*n_name;	/* official name of net */$ 	char		**n_aliases;	/* alias list */( 	int		n_addrtype;	/* net address type */! 	uint32_t	n_net;		/* network # */  	};    struct	servent {* 	char	*s_name;	/* official service name */# 	char	**s_aliases;	/* alias list */  	int	s_port;		/* port # */% 	char	*s_proto;	/* protocol to use */  	};    struct	protoent { + 	char	*p_name;	/* official protocol name */ # 	char	**p_aliases;	/* alias list */  	int	p_proto;	/* protocol # */ 	};    #ifndef IPPORT_RESERVED  #define IPPORT_RESERVED (1024) #endif  ! int *decc$h_errno_get_addr(void); * #define h_errno (*decc$h_errno_get_addr())   struct rpcent { 8 	char	*r_name;	/* name of server for this rpc program */# 	char	**r_aliases;	/* alias list */ ' 	int	r_number;	/* rpc program number */  	};    /*>  * Error return codes from gethostbyname() and gethostbyaddr()   * (left in extern int h_errno).  */ D #define	HOST_NOT_FOUND	(1) /* Authoritative Answer Host not found */I #define	TRY_AGAIN	(2) /* Non-Authoritive Host not found, or SERVERFAIL */ N #define	NO_RECOVERY	(3) /* Non recoverable errors, FORMERR, REFUSED, NOTIMP */G #define	NO_DATA		(4) /* Valid name, no data record of requested type */ > #define	NO_ADDRESS	NO_DATA	/* noaddress, look for MX record */   void endhostent (void);  void endnetent (void); void endprotoent (void); void endservent (void);  void endrpcent  (void); N struct hostent	*gethostbyaddr (const void * __addr, size_t __len, int __type);4 struct hostent	*gethostbyname (const char * __name);" struct hostent	*gethostent (void);9 struct netent	*getnetbyaddr (uint32_t __net, int __type);   
 /* u_long? */ 2 struct netent	*getnetbyname (const char * __name);  struct netent	*getnetent (void);6 struct protoent	*getprotobyname (const char * __name);0 struct protoent	*getprotobynumber (int __proto);$ struct protoent	*getprotoent (void);J struct servent	*getservbyname (const char * __name, const char * __proto);A struct servent	*getservbyport (int __port, const char * __proto); " struct servent	*getservent (void); struct rpcent	*getrpcent(void); + struct rpcent	*getrpcbyname (const char *); $ struct rpcent	*getrpcbynumber (int); void herror (const char *); ! void sethostent (int __stayopen); & /* void	sethostfile (const char *); */  void setnetent (int __stayopen);" void setprotoent (int __stayopen);! void setservent (int __stayopen);  void setrpcent (int);    # ifdef __cplusplus  }  # endif    #endif /* _NETDB_H */ 