/* File: <pwd.h>
 */
/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received acopy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the, 1992 Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

/*
 *	POSIX Standard: 9.2.2 User Database Access	<pwd.h>
 */

/* 28-Jun-1998	J. Malmberg	Some of this stuff is not present
**				in all versions of the DEC C RTL.
**				It is here for assistance in porting
**				programs.
**
** 29-Nov-1998	J. Malmberg	For getpwuid() to work, the uid argument must
**				be 32 bits.
**
** 28-Dec-1998	J. Malmberg	Adjusted to X/OPEN spec
*/

#ifndef	_PWD_H
#define	_PWD_H	1

# ifdef __cplusplus
extern "C" {
# endif

#ifndef _SYS_TYPES_H
#include <sys/types.h>
#endif

/* The passwd structure.  */
struct passwd {
  char *pw_name;		/* Username.  */
  uid_t pw_uid;			/* User ID.  */
  gid_t pw_gid;			/* Group ID. */
  char *pw_dir;			/* Home directory.  */
  char *pw_shell;		/* Shell program.  */
  char *pw_passwd;		/* Password.  [Not in DECC RTL] */
  char *pw_gecos;		/* Real name. [Not in DECC RTL] */
};




/* get name from UID and put it into BUF. */
extern int getpw (uid_t __uid, char *__buf);

#ifdef	__USE_SVID

/* Read an entry from STREAM.  */
extern struct passwd *fgetpwent (FILE * __stream);

/* Write the given entry onto the given stream.  */
extern int putpwent (__const struct passwd * __p, FILE * __f);

#endif

/* Search for an entry with a matching username.  */
extern struct passwd *getpwnam (const char *__name);

/* Search for an entry with a matching user ID.  */
/* extern struct passwd *getpwuid (uid_t __uid); */
/*
** Need 32 bit uid_t on VMS for this function to work
*/
struct passwd	*getpwuid (unsigned long __uid);

int		 getpwname_r
		       (const char *,
			struct passwd *,
			char *,
			size_t,
			struct passwd **);

int		 getpwuid_r
		       (uid_t,
			struct passwd *,
			char *,
			size_t,
			struct passwd **);

void		 endpwent(void);
struct passwd	*getpwent(void);
void		 setpwent(void);
# ifdef __cplusplus
}
# endif

#endif /* pwd.h */
