/* <signal.h>
 *
 *	VAXCRTL/DECCRTL compatible signal definitions.
 */
/*
 * 17-Dec-1998	J. Malmberg	Added VAXC/DECC$CTRL_INIT()
 *
 * 23-Dec-1998	J. Malmberg	Added some X/OPEN required definitions.
 *				Some values required by X/OPEN are not
 *				known.  Some structures and routines
 *				may not be used by the DEC C / VAX C RTL.
 *
 * 28-Dec-1998	J. Malmberg	Added/corrected signals for DEC C RTL
 */

#ifndef _SIGNAL_H
#define _SIGNAL_H
# ifdef __cplusplus
extern "C" {
# endif

#include <sys/types.h>
#include <timers.h>

#ifndef __UNION_SIGVAL
#define __UNION_SIGVAL
union sigval {
    int sigval_int;
    void * sival_ptr;
    };
#endif

#ifndef __STRUCT_SIGEVENT
#define __STRUCT_SIGEVENT
struct sigevent {
	union sigval	 signal_value;	/* signal value */
	int		 sigev_signo;	/* signal number */
	int		 sigev_notify;	/* notification type */

	void (* sigev_notify_function)(union sigval) ;  /* notification funct */

			 /* HACK! sys$library:cma_sigwait.h includes this */
			/*  file before pthread_attr_t is defined.	 */
#ifdef CMA_INCLUDE
	cma_t_handle	*sigev_notify_attributes;
#else
#ifdef _PTHREAD_ATTR_T
	pthread_attr_t	*sigev_notify_attributes;	/* notification attr */
#else
	void		*sigev_notify_attributes;
#endif
#endif
	};
#endif

#ifndef __STACK_T
#define __STACK_T
typedef struct {
	void * ss_sp;		/* stack base or pointer */
	size_t ss_size;		/* stack size */
	int    ss_flags;	/* flags */
   } stack_t;
#endif


#ifndef SIGEV_NONE
#define SIGEV_NONE (0)		/* No asynchrounous notification will be */
				/*    delivered when the event of interest */
				/*    occurs */
#endif

#ifndef SIGEV_SIGNAL
#define SIGEV_SIGNAL (1)	/* A queued signal, with an */
				/*    application-defined value, will */
				/*    be generated when the event of  */
				/*    interest occurs. */
#endif

/*	SIGEV_THREAD ??	*/ /* A notification function will be called */
			   /*   to perform notification */
#if VAXCRTL5X
#define NSIG	(15)	/* OLD VAX C */
#else
#if DECCRTL6X
#define NSIG	(17)	/* number of signals (VAX C has 17, but ends at 15) */
#else
#define NSIG	(64)	/* DEC C 7.x has 64 signals */
#endif
#endif


#define SIGHUP	(1)		/* hangup */
#define SIGINT	(2)		/* interrupt */
#define SIGQUIT (3)		/* quit */
#define SIGILL	(4)		/* illegal instruction (not reset when caught)*/

/*	ILL_ILLOPC	?? */	/* Illegal opcode */
#define ILL_ILLOPN	(2)	/* illegal operand */
#define ILL_ILLADR	(0)	/* illegal addressing mode */
#define ILL_RESAD_FAULT  (0x0)	/* reserved addressing mode fault */
#define ILL_PRIVIN_FAULT (0x1)	/* priviledged instruction fault */
#define ILL_PRVOPC	(1)	/* priviledged opcode */
#define ILL_RESOP_FAULT  (0x2)	/* reserved operand fault */
/*	ILL_PRVREG	?? */	/* priviledged register */
/*	ILL_COPROC	?? */	/* coprocessor error */
/*	ILL_BADSTK	?? */	/* internal stack error */
#define SIGTRAP (5)		/* trace trap (not reset when caught) */
/*	TRAP_BRKPT	?? */	/* process breakpoint */
/*	TRAP_TRACE	?? */	/* process trace trap */
#define SIGIOT	(6)		/* IOT instruction */
#define SIGEMT	(7)		/* EMT instruction */
#define SIGFPE	(8)		/* floating point exception */
#define FPE_INTOVF	(1)	/* integer overflow */
#define FPE_INTOVF_TRAP  (0x1)
#define FPE_INDDIV	(2)	/* integer divide by zero */
#define FPE_INTDIV_TRAP  (0x2)
#define FPE_FLTOVF	(3)	/* floating point overflow */
#define FPE_FLTOVF_TRAP  (0x3)
#define FPE_FLTDIV	(4)	/* floating point divide by zero */
#define FPE_FLTDIV_TRAP  (0x4)
#define FPE_FLTUND	(5)	/* floating point underflow */
#define FPE_FLTUND_TRAP  (0x5)
#define FPE_DECOVF_TRAP  (0x6)
#define FPE_SUBRNG_TRAP  (0x7)
#define FPE_FLTOVF_FAULT (0x8)
#define FPE_FLTDIV_FAULT (0x9)
#define FPE_FLTUND_FAULT (0xa)
/*	FPE_FLTRES	?? */	/* floating point inexact result */
#define	FPE_FLTINV	 (0x0b)	/* invalid floating point operation */
/*	FPE_FLTSUB	?? */	/* subscript out of range */
#define SIGKILL (9)		/* kill (cannot be caught or ignored) */
#define SIGBUS	(10)		/* bus error */
/*	BUS_ADRALN	?? */	/* invalid address alignment */
/*	BUS_ADRERR	?? */	/* non-existant physical address */
/*	BUS_OBJERR	?? */	/* object specific hardware error */
#define SIGSEGV (11)		/* segmentation violation */
/*	SEGV_MAPERR	?? */	/* Address not mapped to object */
/*	SEGV_ACCERR	?? */	/* Invalid permissions for mapped object */
#define SIGSYS	(12)		/* bad argument to system call */
#define SIGPIPE (13)		/* write to a pipe with no one to read it */
#define SIGALRM (14)		/* alarm clock */
#define SIGTERM (15)		/* software termination signal from kill */

#if 1	/* not implemented [yet?] (obtained from Ultrix <signal.h>) */
#define SIGURG	(16)		/* urgent condition on IO channel (wrong?) */
#define SIGUSR1 (16)		/* User signal 1 (from SysV) */
#define SIGUSR2 (17)		/* User signal 2 (from SysV) */
#define SIGSPARE18	(18)	/* reserved */
#define SIGSPARE19	(19)	/* reserved */
#define SIGCHLD (20)		/* to parent on child stop or exit */
/*	CLD_EXITED	?? */	/* child has exited */
/*	CLD_KILLED	?? */	/* child has terminated abnormally and */
				/*   did not create a core file */
/*	CLD_DUMPED	?? */	/* child has terminated abnormally and */
				/*   did create a core file */
/*	CLD_TRAPPED	?? */	/* traced child has trapped */
/*	CLD_STOPPED	?? */	/* child has stopped */
/*	CLD_CONTINUED	?? */	/* stopped child has continued */
#define SIGCONT (21)		/* continue a stopped process */
#define SIGSTOP (22)		/* sendable stop signal not from tty */
#define SIGIO	(23)		/* input/output possible signal */ /* wrong? */
#define SIGTSTP (23)		/* stop signal from tty */
#define SIGXCPU (24)		/* exceeded CPU time limit */ /* wrong ? */
#define SIGTTIN (24)		/* to readers pgrp upon background tty read */
#define SIGTTOU (25)		/* like TTIN for output if */
				/*    (tp->t_local&LTOSTOP) */
#define SIGXFSZ (25)		/* exceeded file size limit (wrong?) */
#define SIGDEBUG	(26)	/* Permanently reserved to Digital */
#define SIGVTALRM (26)		/* virtual time alarm (wrong ?) */
#define SIGSPARE27	(27)	/* reserved */
#define SIGPROF (27)		/* profiling time alarm (wrong ?) */
#define SIGSPARE28	(28)	/* reserved */
#define SIGWINCH (28)		/* window size changes (wrong ?) */
#define SIGSPARE29	(29)	/* reserved */
#define SIGLOST (29)		/* Sys-V rec lock: notify user upon server */
				/*   crash (wrong ?) */
#define SIGSPARE30	(30)	/* reserved */
#define SIGSPARE31	(31)	/* reserved */
#define SIGSPARE32	(32)	/* reserved */
#define SIGRTMIN (33)		/* Lowest realtime signal */
#define SIGRTMAX (64)		/* Highest realtime signal */
#define SIGCLD	SIGCHLD		/* SysV */
#define SIGABRT SIGIOT		/* BRL */
#endif	/* not implemented */

/*	SIGPOLL ??	*/	/* Pollable event */
/*	POLL_IN		?? */	/* data input available */
/*	POLL_OUT	?? */	/* output buffers available */
/*	POLL_MSG	?? */	/* input message available */
/*	POLL_ERR	?? */	/* I/O error */
/*	POLL_PRI	?? */	/* High priority input available */
/*	POLL_HUP	?? */	/* device disconnected */
/*	SI_USER		?? */	/* signal sent by kill() */
/*	SI_QUEUE	?? */	/* signal sent by sigqueue() */
/*	SI_TIMER	?? */	/* signal generated by expiration of a */
				/*   timer set by timer_settime() */
/*	SI_ASYNCIO	?? */	/* signal generated by completion of an */
				/*   asynchronous I/O request */
/*	SI_MESGQ	?? */	/* signal generated by arrival of a message */
				/*   on an empty message queue */

#ifndef RTSIG_MAX
#define RTSIG_MAX (32)
#endif

#if !defined(_SIG_ATOMIC_T) && !defined(_SIG_ATOMIC_T_)
typedef long sig_atomic_t;
#endif
#define _SIG_ATOMIC_T
#define _SIG_ATOMIC_T_
#if !defined(_SIGSET_T) && !defined(_SIGSET_T_)
typedef int  sigset_t;
#endif
#define _SIGSET_T
#define _SIGSET_T_

#define SV_ONSTACK	(01)
#define SA_ONSTACK	(01)
#define SV_INTERRUPT	(02)
#define SA_RESETHAND	(02)
#define SA_NOCLDSTOP	(04)
#define SA_NODEFER	(8)
#define SV_OLDSIG	(010000)	/*(from Ultrix /usr/include/signal.h)*/
#define SA_SIGINFO	(0x08)		/* Causes extra information to be */
					/* passed to signal handlers at the */
					/* time of receipt of a signal */

#define SIG_BLOCK	(1)		/* The resulting set is the union */
					/* of the current set and the */
					/* signal set pointed to by the */
					/* argument set */

#define SIG_UNBLOCK	(0)		/* The resulting set is the */
					/* intersection of the current */
					/* set and the complement of */
					/* signal set pointed to by the */
					/* argument set */
#define SIG_SETMASK	(2)		/* The resulting set is the signal */
					/* set pointed to by the argument set.*/

/* 	SA_RESTART	??	*/	/* Causes certain function to */
					/* become restartable */

/*	SA_NOCLDWAIT	??	*/	/* Causes implementations not to */
					/* create zombie processes on */
					/* child death. */

/*	SS_ONSTACK	??	*/	/* Process is executing on an */
					/* alternate signal stack */

/*	SS_DISABLE	??	*/	/* Alternate signal stack is */
					/* disabled */

/*	MINSIGSTKSZ	??	*/	/* Process is executing on an */
					/* alternate signal stack */

/*	SIGSTKSZ	??	*/	/* Default size in bytes for the */
					/* alternate signal stack */

struct sigvec {
	void	(*sv_handler)();	/* handler address */
	sigset_t sv_mask;		/* mask of signals to be blocked */
	int	sv_flags;		/* flag to indicate signal stack */
#define sv_onstack sv_flags		/* old name for flags */
};
struct sigaction {	/* POSIX version of the above */
	void	(*sa_handler)();
	sigset_t sa_mask;
	int	sa_flags;
};
#define sa_sigaction sa_handler	/* Comply with X/OPEN */

struct sigcontext {
	int	sc_onstack;		/* signal stack flag to restore */
	int	sc_mask;		/* signal mask to restore */
	int	sc_sp;			/* stack pointerto restore */
	int	sc_pc;			/* pc to return to */
	int	sc_ps;			/* psl to restore */
};
struct sigstack {
	char	*ss_sp;			/* signal stack pointer */
	int	ss_onstack;		/* current status */
};

#ifndef __SIGINFO_T
#define __SIGINFO_T
typedef struct {
	int si_signo;		/* Signal number */
	int si_code;		/* Signal code */
	union sigval si_value;	/* Signal value */
	int si__vmssigarray[9];	/* Copy of original argument list */
	/* The following not defined in DEC POSIX / required by XOPEN */
	int si_errno;
	pid_t si_pid;		/* Sending process id */
	uid_t si_uid;		/* real user id of sending process */
	void *si_addr;		/* Address of faulting instruction */
	long si_band;		/* band event for SIGPOLL */
    } siginfo_t;
#endif

#ifdef __STDC__

# ifdef VMS_SIGNALS
	/* Additional arguments above and beyond the signal number.
	   Presence of these optional arguments makes type-correct
	   declarations just about impossible unless __SIG_ARGS is
	   used.  Default action is to ignore the extra arguments and
	   pretend that we're dealing with vanilla ANSI-sanctioned
	   signals.
	 */
# define __SIG_ARGS int,...
# else
	/* portable arguments instead of full VMS signals */
# define __SIG_ARGS int
# endif

# define SIG_ERR ((void (*)(__SIG_ARGS)) -1)	/* invalid */
# define SIG_DFL ((void (*)(__SIG_ARGS)) 0)	/* default */
# define SIG_IGN ((void (*)(__SIG_ARGS)) 1)	/* ignore */
/*	 SIG_HELD ??			*/	/* held */
# define BADSIG  SIG_ERR		/* pre-ANSI name */

void (*signal(int,void (*)(__SIG_ARGS)))(__SIG_ARGS);
void (*ssignal(int,void (*)(__SIG_ARGS)))(__SIG_ARGS);

/* int alarm(unsigned); */	/* note: returns int, not unsigned */
unsigned alarm(unsigned int __seconds);	/* ISO POSIX 1 unsigned, old int */
int gsignal(__SIG_ARGS);	/* functionally equivalent to raise(), but works! */
int kill(pid_t, int);
int pause(void);
int raise(int);			/* note: as of VMS V5.4, missing from VAXCRTL */
int sigaction
       (int __sig,
	const struct sigaction * __inaction,
	struct sigaction * __o_action);
int sigaddset(sigset_t * __set, int __sig_number);
int sigblock(int);
int sigdelset(sigset_t * __set, int __sig_number);
int sigemptyset(sigset_t * __set);
int sigfillset(sigset_t * __set);
int sigismember(sigset_t * __set, int __sig_number);
int sigmask(int __sig);
#define sigmask(__m) (1L <<(__m) - 1))
int sigpause(int);
int sigpending(sigset_t * __set);
int sigprocmask(int __how, const sigset_t * __set, sigset_t * __o_set);
int sigsetmask(int);
int sigstack(struct sigstack *,struct sigstack *);
int sigsuspend(const sigset_t * __signal_mask);
int sigvec(int,struct sigvec *,struct sigvec *);


		/* prev note: sleep() returns int, not unsigned */
		/* x/open says sleep() returns unsigned int	*/
unsigned int sleep(unsigned);

/* condition handler capable of dealing with setjmp/longjmp */
#ifndef _VAXC$ESTABLISH_P
#define _VAXC$ESTABLISH_P
/* void VAXC$ESTABLISH(unsigned long (*)(unsigned long *,unsigned long *)); */
/* this prototype matches VAX C's, but the one above is more appropriate */
void VAXC$ESTABLISH(int (*)(void *,void *));
#endif

 /* bsd_signal, killpg, ... not documented in DEC C RTL, VAX C RTL */
/*----------------------------------------------------------------*/
void (*bsd_signal(int, void (*)(int)))(int);
int killpg(pid_t, int);

 /* HACK! This header is called by cma_sigwait, before pthread_t is typedef */
#ifdef _PTHREAD_ATTR_T
int pthread_kill(pthread_t, int);
#else
#ifdef CMA_INCLUDE
int pthread_kill(cma_t_thread, int);
#endif
#endif
int pthread_sigmask(int, const sigset_t *, sigset_t *);

int sigaltstack(const stack_t *, stack_t *);
int sighold(int);
int sigignore(int);
int siginterrupt(int, int);
int sigmember(const sigset_t *, int);
int sigqueue(pid_t, int, const union sigval);
int sigrelse(int);
int (*sigset(int, void (*)(int)))(int);
int sigtimedwait(const sigset_t *, siginfo_t *, const struct timespec *);
int sigwait(const sigset_t * set, int * sig);
int sigwaitinfo(const sigset_t *, siginfo_t *);

#else	/*!__STDC__ => -traditional */

# define SIG_ERR ((void (*)()) -1)
# define SIG_DFL ((void (*)()) 0)
# define SIG_IGN ((void (*)()) 1)
# define BADSIG  SIG_ERR

void (*signal(int, void(*)(int))) (int);
void (*ssignal(int sig, void(*)(int, ...))) (int,... );
int alarm(), gsignal(), kill(), pause(), raise(), sleep();
int sigblock(), sigpause(), sigsetmask(), sigstack(), sigvec();
void VAXC$ESTABLISH();

#endif	/*?__STDC__*/

void DECC$CRTL_INIT(void);
void VAXC$CRTL_INIT(void);

# ifdef __cplusplus
}
# endif
#endif	/*_SIGNAL_H*/
