/* <stdio.h>
 *
 *	This defines a VAXCRTL compatible standard I/O interface.
 */
/*
 * 17-Dec-1998	J. Malmberg	Add DECC$ routine prototypes
 * 28-Dec-1998	J. Malmberg	Adjusted to match X/OPEN
 */

#ifndef _STDIO_H
#define _STDIO_H
# ifdef __cplusplus
extern "C" {
# endif

#if defined(__STDC__) && !defined(_STDDEF_H)
#include <stddef.h>	/* get size_t, NULL */
#endif

/*
 *	The maximum number of files we can have open at a time
 *	(not really; blocks of this many are chained together by vaxcrtl)
 */
#define _NFILE 20

/*
 *	STDIO buffer size
 */
#define BUFSIZ 8192

#ifndef _IOBUF_S
#define _IOBUF_S
/*
 *	This is what the VAXCRTL stdio FILE structure looks like
 */
struct	_iobuf	{
	int	_cnt;			/* # of characters in the buffer */
	char	*_ptr;			/* Pointer into the buffer	 */
	char	*_base;			/* Pointer to start of buffer	 */
	unsigned char	_flag;		/* STDIO flags			 */
#define _IOREAD		0001			/* Open for reading	 */
#define _IOWRT		0002			/* Open for writing	 */
#define _IONBF		0004			/* No buffer		 */
#define _IOFBF          2			/* fully buffered	*/
#define _IOLBF          1			/* line buffered	*/
#define _IOMYBUF	0010			/* Using "my" buffer	 */
#define _IOEOF		0020			/* At End Of File	 */
#define _IOERR		0040			/* I/O error has occured */
#define _IOSTRG		0100			/* Doing I/O to a string */
#define _IORW		0200			/* Open for read/write	 */
#if __CRTL_VER >= 70000000
	unsigned char _padfile;
	unsigned char _pad1;
	unsigned char _pad2;
	int	      _file;
#else
	unsigned char _file;		/* File descriptor		 */
	unsigned char _pad1;
	unsigned char _pad2;
#endif
};
#endif

/*
 *	Instead of passing around pointers to _iobuf structures, VAXCRTL
 *	passes around pointers to pointers.
 */
#ifndef _FILE_T
#define _FILE_T
typedef struct _iobuf *FILE;
#endif
/*
 *	Cookie used by fgetpos() and fsetpos() [alternatives to ftell/fseek]
 *	Internally, it's a 6-byte RFA plus a 2-byte offset within record.
 */
#ifndef fpos_t
typedef struct {
	unsigned : 32;
	unsigned : 32;
	} fpos_t;
#endif
/*
 *	Also, stdin/stdout/stderr need to be defined
 *	[We also use a hack here that makes the GCC assembler modify
 *	 the psect attributes to match those of the VAXCRTL]
 */
extern FILE *stdin	__asm("_$$PsectAttributes_NOSHR$$stdin");
extern FILE *stdout	__asm("_$$PsectAttributes_NOSHR$$stdout");
extern FILE *stderr	__asm("_$$PsectAttributes_NOSHR$$stderr");

/*
 *	Define NULL and EOF
 */
#ifndef __STDC__	/* got it from <stddef.h> if __STDC__ */
#define NULL ((void *)0)
#endif
#define EOF	(-1)

#ifndef SEEK_SET
#define SEEK_SET 0
#endif
#ifndef SEEK_SET
#define SEEK_CUR 1
#endif
#ifndef SEEK_SET
#define SEEK_END 2
#endif
#ifndef SEEK_EOF
#define SEEK_EOF SEEK_END	/* VAX C compatability */
#endif

#define FOPEN_MAX 8	/* minimum number simultaneously open files */
#define OPEN_MAX  8	/* ditto (note: minimum _guaranteed_; more possible) */
#define TMP_MAX  32	/* minimum number of unique names tmpnam() gives */
#if 0
#define FILENAME_MAX 39 /* longest filename [should be 255; see below] */
#else
#define FILENAME_MAX 256 /* Per ANSI standard (1025 with ODS-5) */
#endif

/*
 *	Buffer sizes for various return values
 */
#define L_ctermid	64	/* size of device name */
#define L_cuserid	16	/* size of user name */
#define L_tmpnam	256	/* size of file name */
#define L_lcltmpnam	256	/* size of file local name */
#define L_nettmpnam	256	/* size of file network name */

#define P_tmpdir "SYS$SCRATCH:"

/* formatted input/output */
#ifndef _VA_LIST_T_
#define _VA_LIST_T_
   typedef char * __va_list_t;
#endif

#if !defined(_OFF_T) && !defined(_OFF_T_)
typedef int off_t;				/* Used for file sizes */
#endif
#define _OFF_T
#define _OFF_T_

/*
 *	Define the stdio macros; note that getc and putc are function calls.
 */
#ifdef __STDC__ /* these usually-macros have functions backing them */
int	getchar(void);
int	putchar(int);
#endif		/* most of the others should too, but don't as of V5.4-3 */
#define getc(fp)	fgetc(fp)
#define getchar()	fgetc(stdin)
#define putc(x,fp)	fputc((x),fp)
#define putchar(x)	fputc((x),stdout)
#define feof(fp)	(((*fp)->_flag & _IOEOF)!=0)
#define ferror(fp)	(((*fp)->_flag & _IOERR)!=0)
#define fileno(fp)	((*fp)->_file)
#define clearerr(fp)	((*fp)->_flag &= ~(_IOERR|_IOEOF))

/* Prototypes required by X/OPEN */
void	 (clearerr)(FILE *);
char	*(ctermid)(char *);
char	*(cuserid)(char *);	/* legacy */
int	 (feof)(FILE *);
int	 (ferror)(FILE *);
int	 (fileno)(FILE *);
void	 flockfile(FILE *);	/* Not documented in DEC C RTL */
int	 (fputc)(int, FILE *);
int	 ftrylockfile(FILE *);	/* Not documented in DEC C RTL */
void	 funlockfile(FILE *);	/* Not documented in DEC C RTL */
int	 (getc)(FILE *);
int	 getc_unlocked(FILE *);	/* Not documented in DEC C RTL */
int	 getchar_unlocked(void);	/* Not documented in DEC C RTL */
int	 (putc)(int, FILE *);
int	 putc_unlocked(int, FILE *);	/* Not documented in DEC C RTL */
int	 putchar_unlocked(int);	/* Not documented in DEC C RTL */
int	 rename(const char *, const char *);
int	 vsnprintf(char *, size_t, const char *, __va_list_t);

 /* getopt is now here and in stdio.h according to X/OPEN */
/*-------------------------------------------------------*/
int	 getopt(int, char * const [], const char *); /* LEGACY */

extern int   optind; /* legacy */
extern int   opterr;
extern int   optopt;
extern char *optarg;


/* VAX C compatibility */
#define vaxc$record_read(fp,buf,max_size) read(fileno(fp),(buf),(max_size))
#define vaxc$record_write(fp,buf,size) fwrite((buf),(size),1,(fp))

int decc$read(int __file_desc, void *__buffer, int __nbytes);
#define decc$record_read(__fp, __buffer, __nbytes) \
	decc$read(((*(__fp))->_file), (__buffer), (__nbytes))
#define decc$record_write(__fp, __buffer, __nbytes) \
	fwrite((__buffer), (__nbytes), 1, (__fp))

void perror(const char *__str);

/*
 *	Check for alternate representation of doubles; affects formatted I/O.
 */
#ifdef __GFLOAT__
# define scanf		vaxc$gscanf
# define printf		vaxc$gprintf
# define vprintf	vaxc$gvprintf
# define fscanf		vaxc$gfscanf
# define fprintf	vaxc$gfprintf
# define vfprintf	vaxc$gvfprintf
# define sscanf		vaxc$gsscanf
# define sprintf	vaxc$gsprintf
# define vsprintf	vaxc$gvsprintf
#endif

/*
 *	Declare stdio routines
 */
#ifdef __STDC__

/* access */
FILE	*fopen(const char *, const char *,...);
FILE	*fdopen(int, const char *);
FILE	*freopen(const char *, const char *, FILE *, ...);
int	 fflush(FILE *);
int	 fclose(FILE *);

/* unformatted input/output */
int	 fgetc(FILE *file_ptr);
int	 ungetc(int,FILE *);
int	 fputc(int,FILE *);
int	 getw(FILE *file_ptr);
int	 putw(int, FILE *);
char	*gets(char *);
int	 puts(const char *);
char	*fgets(char *,int,FILE *);
int	 fputs(const char *, FILE *);
size_t	 fread(void *, size_t, size_t, FILE *);
size_t	 fwrite(const void *, size_t, size_t, FILE *);

int	 scanf(const char *,...);
int	 printf(const char *,...);
int	 vprintf(const char *, __va_list_t);
int	 fscanf(FILE *, const char *, ...);
int	 fprintf(FILE *, const char *,...);
int	 vfprintf(FILE *,const char *,__va_list_t);
int	 sscanf(const char *,const char *,...);
int	 sprintf(char *,const char *,...);
int	 vsprintf(char *,const char *,__va_list_t);
# undef __va_list_t

/* positioning */
int	 fseek(FILE *, long, int);
int	 fseeko(FILE *, off_t, int);	/* Not documented in DEC C RTL */
long	 ftell(FILE *);
off_t	 ftello(FILE *);		/* Not documented in DEC C RTL */
int	 fwait(FILE * __stream);
int	 fsetpos(FILE *, const fpos_t *);
int	 fgetpos(FILE *,fpos_t *);
int	 rewind(FILE *);

/* miscellaneous */
void	 perror(const char *);
#ifndef unlink
#define unlink(name) remove (name)
#endif
int	 pclose(FILE * __stream);
FILE	*popen(const char *__command, const char * __mode);
int	 remove(const char *);
void	 setbuf(FILE *,char *);
int	 setvbuf(FILE *,char *,int,size_t);
char	*fgetname(FILE *,char *,...); /* optional arg is VMS vs shell name format */
char	*tmpnam(char *);
FILE	*tmpfile(void);
char	*tempnam(const char * __directory, const char * __prefix);

#else	/*!__STDC__ => -traditional */

FILE	*fopen(), *fdopen(), *freopen();
int	 fflush(), fclose();
int	 fgetc(), ungetc(), fputc(), getw(), putw(), puts(), fputs();
char	*gets(), *fgets();
unsigned fread(), fwrite();
int	 scanf(), fscanf(), sscanf();
int	 printf(), fprintf(), sprintf(), vprintf(), vfprintf(), vsprintf();
long	 ftell();
int	 fseek(), fgetpos(), fsetpos(), rewind();
void	 perror(), setbuf();
int	 remove();
int	 setvbuf();
char	*fgetname(), *tmpnam();
FILE	*tmpfile();

#endif	/*?__STDC__*/

# ifdef __cplusplus
}
# endif
#endif	/*_STDIO_H*/
