/* <string.h>
 *
 *	Run-time library string manipulation functions, per ANSI.
 */
/*
** 22-Dec-1998	J. Malmberg	Added new stuff in DECC RTL
*/
#ifndef _STRING_H
#define _STRING_H
# ifdef __cplusplus
extern "C" {
# endif
			/* note: not the same as <strings.h> */
			/* n.b.: no !defined(__STDC__) handling */
#ifndef _STDDEF_H
#include <stddef.h>	/* get size_t, NULL */
#endif

#ifdef GCC_STRINGS
/*
   Rename some routines available from GCCLIB so that they're guaranteed
   not to produce linker problems by conflicting with similar ones in
   VAXCRTL.  They're present in order to work-around a serious bug in
   strncat() [still present as of VMS V5.5-1], where it will fall into
   an infinite loop if the source string's length is more than 65535
   characters longer than the number being copied.  The set of routines
   corresponds to those of module C$STRINGS in VAXCRTL.
 */
#define strlen	gcc_strlen
#define strcpy	gcc_strcpy
#define strcat	gcc_strcat
#define strncpy gcc_strncpy
#define strncat gcc_strncat
#define strspn	gcc_strspn
#define strcspn gcc_strcspn
#define strpbrk gcc_strpbrk
#endif	/*GCC_STRINGS*/

void	*memccpy(void * __dst, const void * __src, int __c, size_t __n);
void	*memchr(const void *__mem, int __trg, size_t __cnt);
int	 memcmp(const void *__lft, const void *__rgt, size_t __cnt);
void	*memcpy(void *__dst, const void *__src, size_t __cnt);
void	*memmove(void *__dst, const void *__src, size_t __cnt);
void	*memset(void *__mem, int __val, size_t __cnt);

char	*strcat(char *__dst, const char *__src);
char	*strchr(const char *__str, int __chr);
int	 strcmp(const char *__lft, const char *__rgt);
int	 strcoll(const char * __str1, const char * __str2);
char	*strcpy(char *__dst, const char *__src);
size_t	 strcspn(const char *__str, const char *__set);
#ifndef _VAXCRTL_
char	*strdup(const char * s);
#endif

#ifndef _STRERROR_P
#define _STRERROR_P
char	*strerror(int __err, ...);	/* 2nd arg used iff 1st is EVMSERR */
#endif

size_t	 strlen(const char *__str);
size_t	 strnlen(const char *__str, size_t __len);
char	*strncat(char *__dst, const char *__src, size_t __cnt);
int	 strncmp(const char *__lft, const char *__rgt, size_t __cnt);
char	*strncpy(char *__dst, const char *__src, size_t __cnt);
char	*strpbrk(const char *__str, const char *__set);
char	*strrchr(const char *__str, int __chr);
size_t	 strspn(const char *__str, const char *__set);
char	*strstr(const char *__str, const char *__sub);
char	*strtok(char *__tkn, const char *__str);

	/* strtok_r is not documented to be in DEC C RTL */
char	*strtok_r(char *, const char *,char * *);

	/* strsep is not in X/OPEN but in BSD 4.4 */
char	*strsep(char * __stringp[], const char * __delim);

size_t	 strxfrm(char * __s1, const char * __s2, size_t __maxlen);




char	*hstrerror(int __errnum);

# ifdef __cplusplus
}
# endif
#endif	/*_STRING_H*/
