/* <sys/stat.h>
 *
 *	VAXCRTL compatible stat definition.
 *
 * Modifications:
 * 4.3.94: Klaus Kaempf (kkaempf@didymus.rmi.de)
 *		added S_ISCHR definition
 *		added S_ISREG definition
 *
** 27-Jun-1998	J. Malmberg	Added an explaination about the FIXED_INO_T.
** 05-Jul-1998	J. Malmberg	added S_IWOTH definition
**		     *		Hack to make ino_t almost work with UNIX
**				code.
**
** 26-Dec-1998	J. Malmberg	Update to better match X/OPEN specification.
 *
 */
#ifndef _SYS_STAT_H
#define _SYS_STAT_H
# ifdef __cplusplus
extern "C" {
# endif

#if !defined(_SYS_TYPES_H) && !defined(_TYPES_)
#include <sys/types.h>		/* off_t, dev_t, ino_t */
#endif

/*
 *	Because of alignment differences between VAX-11 "C" and GNU "C"
 *	we can't normally access any field AFTER st_gid.  To fix this
 *	the macro stat_alignment_fix(statp) makes fields AFTER st_gid
 *	work right.  stat_alignment_fix2(statp) allows st_fab_mrs to be
 *	accessed.
 *
 *	VMS/GCC defines the CPP variable "PCC_ALIGNMENT" if UNIX PCC
 *	style alignment is in effect.  Otherwise, VAX-11 "C" style
 *	alignment is in effect.
 */
#ifdef	PCC_ALIGNMENT
#define stat_alignment_fix(statp) \
	((struct stat *)((char *)statp - sizeof(short)))

#define stat_alignment_fix1(statp) \
	((struct stat *)((char *)statp - sizeof(short) - sizeof(char)))
#endif	/*PCC_ALIGNMENT*/


/* Note that for OpenVMS, For strictly the purposes of a unique number
** identifying a file on a volume, only the first two words are needed.
** Because of this and the size difference of the ino_t structure, you
** must chose which version to use based on your application.
**
** Either definition can break a UNIX program that is relying on UNIX
** behavior, so beware!
**
*/


#ifndef _BLKCNT_T
#define _BLKCNT_T
    typedef long blkcnt_t;
#endif

#ifndef _BLKSIZE_T
#define _BLKSIZE_T
    typedef long blksize_t;
#endif

#define _STAT_T
#define _STAT_T_
typedef struct stat {
	dev_t	st_dev;
#ifdef UNIX_INO_T		/* see <sys/types.h>   */
	ino_t	st_ino;		/* Fake out UNIX code  */
	unsigned short st_ino_rvn;
#else
#ifdef FIXED_INO_T		/* see <sys/types.h> */
	ino_t	st_ino;		/* single 6-byte cookie */
#else
	ino_t	st_ino[3];	/* bogus array, compatible with VAXC */
#endif
#endif
	unsigned short st_mode;
	int	st_nlink;
	unsigned st_uid;
	unsigned short st_gid;	/* <---- The big screw...  VAX-11 "C" doesn't
					do alignment so everything following
					this is wrong! */
	dev_t	st_rdev;
	off_t	st_size;
	time_t	st_atime;
	time_t	st_mtime;
	time_t	st_ctime;
	char	st_fab_rfm;
	char	st_fab_rat;
	char	st_fab_fsz;	/* <---- Another screw */
	unsigned st_fab_mrs;
} stat_t;

 /* An attempt to assist X/OPEN */
/*-----------------------------*/
#ifndef st_blksize
#define st_blksize st_rdev + (512)	/* A lie, but the best that we    */
					/* we can come up with.		  */
					/* DEC & VAX C RTL are documented */
					/* to set st_rdev to 0.		  */
#endif

#ifndef st_blocks
#define st_blocks st_size / (512)	/* VMS always has Module 512	*/
#endif					/* byte blocks */


#define S_IFMT	 (0170000)	 /* type of file */
#define		 S_IFDIR (0040000)	/* directory */
#define		 S_IFCHR (0020000)	/* character special */
#define		 S_IFBLK (0060000)	/* block special */
#define		 S_IFIFO (0010000)	/* FIFO special */
#define		 S_IFLNK (0120000)	/* symbolic link */
#define		 S_IFREG (0100000)	/* regular */

	/* S_IFMPC, and S_IFMPB not in X/OPEN */
#define		 S_IFMPC (0030000)	/* multiplexed char special */
#define		 S_IFMPB (0070000)	/* multiplexed block special */

#define S_ISUID  (0004000)	 /* set user id on execution */
#define S_ISGID  (0002000)	 /* set group id on execution */
#define S_ISVTX  (0001000)	 /* save swapped text even after use */
#define S_IREAD  (0000400)	 /* read permission, owner */
#define S_IWRITE (0000200)	 /* write permission, owner */
#define S_IEXEC  (0000100)	 /* execute/search permission, owner */
#ifndef S_IRUSR
#define S_IRUSR	 (0000400)	/* Read permissions for Owner */
#define S_IWUSR  (0000200)	/* Write and Delete for Owner */
#define S_IXUSR  (0000100)	/* Execute and Directory Read for Group */
#define S_IRWXU  (0000700)	/* Owner Permission Mask */
#endif
#ifndef S_IRGRP
#define S_IRGRP  (0000040)	/* Read permisions for Group */
#define S_IWGRP  (0000020)	/* Write and Delete for Group */
#define S_IXGRP  (0000010)	/* Execute and Directory Read for Group */
#define S_IRWXG  (0000070)	/* Group Permission Mask */
#endif
#ifndef S_IROTH
#define S_IROTH	 (0000004)	 /* Read permissions for others */
#define S_IWOTH  (0000002)	 /* Write permissions for others */
#define S_IXOTH  (0000001)	 /* Execute and Directory Read for Others */
#define S_IRWXO  (0000007)	 /* Others Permission Mask */
#endif

#define S_ISBLK(__m)	(((__m) & S_IFMT) == S_IFBLK)
#define S_ISCHR(__m)    (((__m) & S_IFMT) == S_IFCHR)
#define S_ISDIR(__m)	(((__m) & S_IFMT) == S_IFDIR)
#define S_ISFIFO(__m)	(((__m) & S_IFMT) == S_IFIFO)
#define S_ISREG(__m)	(((__m) & S_IFMT) == S_IFREG)
#define S_ISLNK(__m)	(((__m) & S_IFMT) == S_ISLNK)

 /* Since these are not implemented in DEC C RTL, X/OPEN says make 0 */
#ifndef S_TYPEISMQ
#define S_TYPEISMQ(__buf)	(0)
#endif

#ifndef S_TYPEISSEM
#define S_TYPEISSEM(__buf)	(0)
#endif

#ifndef S_TYPEISSHM
#define S_TYPEISSHM(__buf)	(0)
#endif

#ifdef __STDC__
int	 chmod(const char *, mode_t);
int	 fchmod(int, mode_t);
int	 fstat(int, stat_t *);
int	 lstat(const char *, struct stat *);	/* Not in DEC C RTL */
int	 mkdir(const char *, mode_t, ...);
int	 mkfifo(const char *, mode_t);		/* Not in DEC C RTL */
int	 mknod(const char *, mode_t, dev_t);	/* Not in DEC C RTL */
int	 stat(const char *, stat_t *);
mode_t	 umask(mode_t);

#else	/*!__STDC__ => -traditional */
int  fstat(), stat();
#endif	/*?__STDC__*/

# ifdef __cplusplus
}
# endif
#endif	/*_SYS_STAT_H*/
