/* File: <sys/times.h>
**
** File access and modification times stucture
**
** 28-Dec-1998	J. Malmberg	X/OPEN modifications.
**
**		    *		This file is included by <sys/time.h> to
**				be compatable with older programs.
**
****************************************************************************/

#ifndef _SYS_TIMES_H
#define _SYS_TIMES_H
# ifdef __cplusplus
extern "C" {
# endif


#ifdef _G_clock_t
  /* Found just this line in the file when I started, so will wrap it with  */
 /*  an #ifdef #endif pair so what ever program used it would keep working */
/*------------------------------------------------------------------------*/
extern _G_clock_t times _G_ARGS((struct tms*));
#else

   /*	Now for some confusion.  VAX C and Early DEC C conflict with the */
  /*	X/OPEN standard for the definition of utime()			*/
 /*	Need to guess as to what RTL is being built against	       */
/*--------------------------------------------------------------------*/
#if defined(_DECC_V4_SOURCE) || defined(_VAXCRTL_)

#ifndef _TBUFFER_T
#define _TBUFFER_T
typedef struct tbuffer {
	int	proc_user_time;
	int	proc_system_time;
	int	child_user_time;
	int	child_system_time;
} tbuffer_t;
#endif	/*_TBUFFER_T*/

void	 times(tbuffer_t *);

#else
    /* X/OPEN definition */

 /* Need the definition of clock_t */
/*--------------------------------*/
#include <sys/types.h>

struct tms {
	clock_t tms_utime;
	clock_t tms_stime;
	clock_t tms_cutime;
	clock_t tms_cstime;
};

clock_t times(struct tms *);

#endif
#endif

# ifdef __cplusplus
}
# endif
#endif	/*_SYS_TIMES_H*/
