/*
 * Copyright (c) 1987 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "stdc.h"

#ifdef VMS
#   include <types.h>
#else
#   include <sys/types.h>
#endif

#ifdef VMS
#   include <stddef.h>
#endif

#if defined(LIBC_SCCS) && !defined(lint)
static const char sccsid[] = "@(#)strcasecmp.c	5.9 (Berkeley) 6/1/90";
#endif /* LIBC_SCCS and not lint */

/*
 * This array is designed for mapping upper and lower case letter
 * together for a case independent comparison.  The mappings are
 * based upon ascii character sequences.
 */
static const unsigned char charmap[] = {
	(short int)'\000', (short int)'\001', (short int)'\002',  
	(short int)'\003', (short int)'\004', (short int)'\005',  
	(short int)'\006', (short int)'\007', (short int)'\010', 
	(short int)'\011', (short int)'\012', (short int)'\013', 
	(short int)'\014', (short int)'\015', (short int)'\016', 
	(short int)'\017', (short int)'\020', (short int)'\021', 
	(short int)'\022', (short int)'\023', (short int)'\024',
	(short int)'\025', (short int)'\026', (short int)'\027', 
	(short int)'\030', (short int)'\031', (short int)'\032', 
	(short int)'\033', (short int)'\034', (short int)'\035', 
	(short int)'\036', (short int)'\037', (short int)'\040', 
	(short int)'\041', (short int)'\042', (short int)'\043', 
	(short int)'\044', (short int)'\045', (short int)'\046', 
	(short int)'\047', (short int)'\050', (short int)'\051',
	(short int)'\052', (short int)'\053', (short int)'\054', 
	(short int)'\055', (short int)'\056', (short int)'\057', 
	(short int)'\060', (short int)'\061', (short int)'\062', 
	(short int)'\063', (short int)'\064', (short int)'\065', 
	(short int)'\066', (short int)'\067', (short int)'\070', 
	(short int)'\071', (short int)'\072', (short int)'\073', 
	(short int)'\074', (short int)'\075', (short int)'\076',
	(short int)'\077', (short int)'\100', (short int)'\141', 
	(short int)'\142', (short int)'\143', (short int)'\144', 
	(short int)'\145', (short int)'\146', (short int)'\147', 
	(short int)'\150', (short int)'\151', (short int)'\152', 
	(short int)'\153', (short int)'\154', (short int)'\155', 
	(short int)'\156', (short int)'\157', (short int)'\160', 
	(short int)'\161', (short int)'\162', (short int)'\163',
	(short int)'\164', (short int)'\165', (short int)'\166', 
	(short int)'\167', (short int)'\170', (short int)'\171', 
	(short int)'\172', (short int)'\133', (short int)'\134', 
	(short int)'\135', (short int)'\136', (short int)'\137', 
	(short int)'\140', (short int)'\141', (short int)'\142', 
	(short int)'\143', (short int)'\144', (short int)'\145', 
	(short int)'\146', (short int)'\147', (short int)'\150',
	(short int)'\151', (short int)'\152', (short int)'\153', 
	(short int)'\154', (short int)'\155', (short int)'\156', 
	(short int)'\157', (short int)'\160', (short int)'\161', 
	(short int)'\162', (short int)'\163', (short int)'\164', 
	(short int)'\165', (short int)'\166', (short int)'\167', 
	(short int)'\170', (short int)'\171', (short int)'\172', 
	(short int)'\173', (short int)'\174', (short int)'\175',
	(short int)'\176', (short int)'\177', (short int)'\200', 
	(short int)'\201', (short int)'\202', (short int)'\203', 
	(short int)'\204', (short int)'\205', (short int)'\206', 
	(short int)'\207', (short int)'\210', (short int)'\211', 
	(short int)'\212', (short int)'\213', (short int)'\214', 
	(short int)'\215', (short int)'\216', (short int)'\217', 
	(short int)'\220', (short int)'\221', (short int)'\222',
        (short int)'\223', (short int)'\224', (short int)'\225', 
	(short int)'\226', (short int)'\227', (short int)'\230', 
	(short int)'\231', (short int)'\232', (short int)'\233', 
	(short int)'\234', (short int)'\235', (short int)'\236', 
	(short int)'\237', (short int)'\240', (short int)'\241', 
	(short int)'\242', (short int)'\243', (short int)'\244', 
	(short int)'\245', (short int)'\246', (short int)'\247',
	(short int)'\250', (short int)'\251', (short int)'\252', 
	(short int)'\253', (short int)'\254', (short int)'\255', 
	(short int)'\256', (short int)'\257', (short int)'\260', 
	(short int)'\261', (short int)'\262', (short int)'\263', 
	(short int)'\264', (short int)'\265', (short int)'\266', 
	(short int)'\267', (short int)'\270', (short int)'\271', 
	(short int)'\272', (short int)'\273', (short int)'\274',
	(short int)'\275', (short int)'\276', (short int)'\277', 
	(short int)'\300', (short int)'\301', (short int)'\302', 
	(short int)'\303', (short int)'\304', (short int)'\305', 
	(short int)'\306', (short int)'\307', (short int)'\310', 
	(short int)'\311', (short int)'\312', (short int)'\313', 
	(short int)'\314', (short int)'\315', (short int)'\316', 
	(short int)'\317', (short int)'\320', (short int)'\321', 
	(short int)'\322', (short int)'\323', (short int)'\324', 
	(short int)'\325', (short int)'\326', (short int)'\327', 
	(short int)'\330', (short int)'\331', (short int)'\332', 
	(short int)'\333', (short int)'\334', (short int)'\335', 
	(short int)'\336', (short int)'\337', (short int)'\340', 
	(short int)'\341', (short int)'\342', (short int)'\343', 
	(short int)'\344', (short int)'\345', (short int)'\346',
	(short int)'\347', (short int)'\350', (short int)'\351', 
	(short int)'\352', (short int)'\353', (short int)'\354', 
	(short int)'\355', (short int)'\356', (short int)'\357', 
	(short int)'\360', (short int)'\361', (short int)'\362', 
	(short int)'\363', (short int)'\364', (short int)'\365', 
	(short int)'\366', (short int)'\367', (short int)'\370', 
	(short int)'\371', (short int)'\372', (short int)'\373',
	(short int)'\374', (short int)'\375', (short int)'\376', 
	(short int)'\377',
};

int
strcasecmp(s1, s2)
	const char *s1, *s2;
{
	register const unsigned char *cm = charmap,
			*us1 = (const unsigned char *)s1,
			*us2 = (const unsigned char *)s2;

	while (cm[*us1] == cm[*us2++])
		if (*us1++ == '\0')
			return (0);
	return (cm[*us1] - cm[*--us2]);
}

#if 0 /* unused ###jp### */
int
strncasecmp(s1, s2, n)
	const char *s1, *s2;
	register size_t n;
{
	if (n != 0) {
		register const unsigned char *cm = charmap,
				*us1 = (const unsigned char *)s1,
				*us2 = (const unsigned char *)s2;

		do {
			if (cm[*us1] != cm[*us2++])
				return (cm[*us1] - cm[*--us2]);
			if (*us1++ == '\0')
				break;
		} while (--n != 0);
	}
	return (0);
}
#endif




