 # line 1 "icalc.y"H 	/*== C declarations =================================================*/   /* 16-FEB-1996 ' David Mathog, Biology Division, Caltech  mathog@seqaxp.bio.caltech.edu   H ICALCV.  A very slight modification to ICALC for use on OpenVMS systems.< This puts the results of up to 10 calculations into a symbolB ICALC_OUT.  If there are more than 10, the 11th on do not get into the symbol  For instance:     $ icalc :==$wherever:icalcv  $ define/user sys$output nla0: I  $ icalc 1 + 0 ;2 + 0 ;3 + 0;4 + 0;5 + 0;6 + 0;7 + 0;8 + 0;9 +0;10+0;11+0   # sho sym icalc_outK   ICALC_OUT = "        1,        2,        3,        4,        5,        6, $    7,        8,        9,        10"  ? When run in interactive mode, only the last result will go into  the output symbol.  2 Compilation instructions for DECC and AXP systems:     $ cc/nolis/standard=vaxc icalcv  $ link/nomap icalcv   The link generates one warning:   $ Symbol MATH$TRUNC_G multiply definedA         in module DPML$SHR file SYS$COMMON:[SYSLIB]DPML$SHR.EXE;2     but the program seems to run ok.    P  *******************************************************************************  *$  *  yacc grammar          :  icalc.y  *  *  version               :   *      2.2 of 920317   *      2.1 of 920316   *      2.0 of 911214   *      1.1 of 900816   *      1.0 of 900708   **  *  author                :  Rao V. AkellaK  *                           Research Assistant, Colon Cancer Control Study A  *                           University of Minnesota, Minneapolis   *%  *                           Address: &  *                             E-Mail:;  *                               Internet: rao@cccs.umn.edu <  *                               Bitnet:   rao%moose@umnacvx>  *                             Work:                     Home:M  *                               212 Ontario St. S.E.      2111, 21st Ave. S. @  *                               Suite #202                #S-20P  *                               Minneapolis, MN 55414     Minneapolis, MN 55404I  *                               (612) 627-4151            (612) 339-9982   *#  *  written on            :  900708   *  *  purpose               : B  *    This program is a yacc grammar to parse an infix calculator.  *;  *  date(s) modified      :  920317, 920316, 911214, 900816   *  *  modifications         : N  *  920317:  Fixed a bug in the definition of the "int" (truncation) function,2  *           and added a new alias (trunc) for it.>  *  920316:  Added 1 new command and 2 new pairs of functions.J  *    1) Added '?' command to display a help screen briefly describing all+  *       operators and functions supported. H  *    2) Added 'degtorad' and 'radtodeg' functions to convert degrees toM  *       radians and vice versa.  This should be useful because trigonometric M  *       functions usually take only radian arguments (which are difficult to K  *       specify).  Using these functions, sine of 90 degress can be easily *  *       computed using sin(degtorad(90)).L  *    3) Added a pair of date functions 'caltojul' and 'jultocal'.  This canL  *       typically be used to determine the difference (in days) between twoG  *       given dates.  These functions assume the base of the Gregorian 7  *       calendar is October 15, 1582 (=julian day #1). L  *       The 'caltojul' function should be invoked as caltojul(yyyy, mm, dd)O  *       where yyyy is the full 4-digit year number (eg. 1992), mm is the month L  *       number (rane 1-12) and dd is the day number (range 1-31).  caltojulC  *       returns the number of days elapsed since October 15, 1582. L  *       The 'jultocal' function takes a julian day as input and returns theL  *       corresponding calendar date as an integer (in the format yyyymmdd).O  *       So, jultocal(1) should return 15821015, which stands for Oct 15, 1582.   *  911214: O  *    Minor change: allow any number of expressions on a line, separated by ';' I  *    Major change: icalc can now be run either interactively (when it is L  *                  invoked without any arguments, in which case the user isK  *                  prompted for input) or in a command-line mode (when all F  *                  expressions to be computed are passed to icalc viaO  *                  command-line "argv" arguments, in which case icalc computes M  *                  and prints the result of each expression -- exactly as if I  *                  it had been entered interactively -- and then exits). H  *                  In the latter case, the user is supposed to delimit/3  *                  separate the expressions by ';'   *  900816: K  *    Added a check to yylex() so that tolower() is invoked (to convert all O  *    symbol names to lower case) only if the input character is in upper case. O  *    Some systems have the isupper() check built into tolower(), and therefore L  *    work OK even without this change, but other systems return unspecified<  *    results if a lower-case character is fed to tolower().  *&  *  invoked by            :  The user.  *  *  functions called      : ;  *    init_table: Puts math/trig functions in symbol table. !  *    yyparse:    Grammar Parser.    *    yyerror:    Error Handler.E  *    yylex:      Lexical Analyzer to supply tokens by parsing input. 1  *    getsym:     Look-up symbol in symbol table. 1  *    putsym:     Install symbol in symbol table. L  *    my_getchar: Return a single character to yylex(), either read from theI  *                keyboard (in interactive mode) or from the command-line :  *                "argv" arguments (in command-line mode).*  *   help:        Display the help screen.6  *   caltojul:    Convert calendar date to julian day.6  *   jultocal:    Convert julian day to calendar date.-  *   degtorad:    Convert degrees to radians. -  *   radtodeg:    Convert radians to degrees. 1  *   trunc:       Returns its truncated argument.   *  *  inputs                : M  *    Math expression to be calculated, input by the user at the keyboard (in O  *    interactive mode) or supplied via command-line arguments (in command-line   *    mode).  *  *  outputs               : ;  *    The resultant computed value of the input expression.   *  *  instructions for use  : M  *    This is an "infix" calculator, so any infix expression will be computed   *    and the result displayed. D  *    In VAX/VMS, type Ctrl-Z, Ctrl-Y or Ctrl-C to exit the program.9  *    In Unix, type Ctrl-D or Ctrl-C to exit the program. E  *    In PC/MS-DOS, type Ctrl-C or Ctrl-Z+Return to exit the program.   *  *  notes                 : I  *    Let me make one thing perfectly clear.  I am NOT the author of this L  *    program.  I merely copied it verbatim out of the "Bison" manual of theO  *    "Free Software Foundation, Inc.", made some cosmetic changes to customize J  *    it to my particular taste, ran it through "yacc", compiled it with a&  *    C compiler, and voila! it works.  *O  *    Motivation: I wanted an "infix" calculator for my day-to-day work.  There J  *    is a plethora of Reverse Polish Notation calculators in Unix and theE  *    public domain, but I haven't seen many infix calculators around O  *    (presumably because they're a bit harder to program than RPN calculators? J  *    Or maybe I haven't been looking hard enough).  I remembered seeing aJ  *    bison/yacc grammar example to parse an infix calculator in the BisonE  *    manual of FSF, Inc., and since the manual permits me to copy it L  *    (provided FSF is given proper copyright and credit, and this resultingJ  *    code is placed in the public domain), I used it as a starting point,<  *    and simply made a FEW modifications to suit my tastes.  *J  *   Since using the Bison manual example mandates me to include the FSF'sM  *   copyright, their permission notice, the "GNU General Public License" and M  *   "Conditions for Using Bison" in the resulting derived work, here goes...   7 Copyright (C) 1988, 1989 Free Software Foundation, Inc.   D Permission is granted to make and distribute verbatim copies of thisC manual provided the copyright notice and this permission notice are  preserved on all copies.  A Permission is granted to copy and distribute modified versions of D this manual under the conditions for verbatim copying, provided also= that the sections entitled ``GNU General Public License'' and = ``Conditions for Using Bison'' are included exactly as in the @ original, and provided that the entire resulting derived work isD distributed under the terms of a permission notice identical to this one.  A Permission is granted to copy and distribute translations of this E manual into another language, under the above conditions for modified @ versions, except that the sections entitled ``GNU General PublicD License'', ``Conditions for Using Bison'' and this permission notice= may be included in translations approved by the Free Software . Foundation instead of in the original English.   Conditions for Using Bison **************************  D Bison grammars can be used only in programs that are free software. C This is in contrast to what happens with the GNU C compiler and the  other GNU programming tools.  ; The reason Bison is special is that the output of the Bison E utility--the Bison parser file--contains a verbatim copy of a sizable C piece of Bison, which is the code for the `yyparse' function.  (The @ actions from your grammar are inserted into this function at one4 point, but the rest of the function is not changed.)  A As a result, the Bison parser file is covered by the same copying B conditions that cover Bison itself and the rest of the GNU system:B any program containing it has to be distributed under the standard GNU copying conditions.   : Occasionally people who would like to use Bison to develop) proprietary programs complain about this.   D We don't particularly sympathize with their complaints.  The purposeD of the GNU project is to promote the right to share software and theE practice of sharing software; it is a means of changing society.  The D people who complain are planning to be uncooperative toward the rest; of the world; why should they deserve our help in doing so?   > However, it's possible that a change in these conditions mightC encourage computer companies to use and distribute the GNU system.  A If so, then we might decide to change the terms on `yyparse' as a ? matter of the strategy of promoting the right to share.  Such a ; change would be irrevocable.  Since we stand by the copying B permissions we have announced, we cannot withdraw them once given.  E We mustn't make an irrevocable change hastily.  We have to wait until C there is a complete GNU system and there has been time to learn how ! this issue affects its reception.    GNU GENERAL PUBLIC LICENSE **************************  0                         Version 1, February 1989  6      Copyright (C) 1989 Free Software Foundation, Inc.+      675 Mass Ave, Cambridge, MA 02139, USA        A      Everyone is permitted to copy and distribute verbatim copies >      of this license document, but changing it is not allowed.  	  Preamble 	 =========   E   The license agreements of most software companies try to keep users A at the mercy of those companies.  By contrast, our General Public A License is intended to guarantee your freedom to share and change D free software--to make sure the software is free for all its users. D The General Public License applies to the Free Software Foundation'sD software and to any other program whose authors commit to using it. & You can use it for your programs, too.  B   When we speak of free software, we are referring to freedom, notD price.  Specifically, the General Public License is designed to makeB sure that you have the freedom to give away or sell copies of freeD software, that you receive source code or can get it if you want it,@ that you can change the software or use pieces of it in new free4 programs; and that you know you can do these things.  B   To protect your rights, we need to make restrictions that forbidF anyone to deny you these rights or to ask you to surrender the rights.C These restrictions translate to certain responsibilities for you if ; you distribute copies of the software, or if you modify it.   D   For example, if you distribute copies of a such a program, whetherE gratis or for a fee, you must give the recipients all the rights that D you have.  You must make sure that they, too, receive or can get the2 source code.  And you must tell them their rights.  D   We protect your rights with two steps: (1) copyright the software,B and (2) offer you this license which gives you legal permission to, copy, distribute and/or modify the software.  F   Also, for each author's protection and ours, we want to make certainA that everyone understands that there is no warranty for this free E software.  If the software is modified by someone else and passed on, = we want its recipients to know that what they have is not the D original, so that any problems introduced by others will not reflect% on the original authors' reputations.   @   The precise terms and conditions for copying, distribution and modification follow.  .                           TERMS AND CONDITIONS  @   1. This License Agreement applies to any program or other workE      which contains a notice placed by the copyright holder saying it >      may be distributed under the terms of this General PublicD      License.  The ``Program'', below, refers to any such program or?      work, and a ``work based on the Program'' means either the C      Program or any work containing the Program or a portion of it, =      either verbatim or with modifications.  Each licensee is       addressed as ``you''.  A   2. You may copy and distribute verbatim copies of the Program's D      source code as you receive it, in any medium, provided that you<      conspicuously and appropriately publish on each copy anB      appropriate copyright notice and disclaimer of warranty; keepE      intact all the notices that refer to this General Public License ;      and to the absence of any warranty; and give any other D      recipients of the Program a copy of this General Public LicenseC      along with the Program.  You may charge a fee for the physical        act of transferring a copy.  E   3. You may modify your copy or copies of the Program or any portion @      of it, and copy and distribute such modifications under the>      terms of Paragraph 1 above, provided that you also do the      following:   E         * cause the modified files to carry prominent notices stating D           that you changed the files and the date of any change; and  E         * cause the whole of any work that you distribute or publish, C           that in whole or in part contains the Program or any part >           thereof, either with or without modifications, to beD           licensed at no charge to all third parties under the termsD           of this General Public License (except that you may chooseD           to grant warranty protection to some or all third parties,           at your option).  9         * If the modified program normally reads commands A           interactively when run, you must cause it, when started C           running for such interactive use in the simplest and most E           usual way, to print or display an announcement including an D           appropriate copyright notice and a notice that there is noD           warranty (or else, saying that you provide a warranty) and=           that users may redistribute the program under these E           conditions, and telling the user how to view a copy of this !           General Public License.   E         * You may charge a fee for the physical act of transferring a D           copy, and you may at your option offer warranty protection            in exchange for a fee.  B      Mere aggregation of another independent work with the ProgramA      (or its derivative) on a volume of a storage or distribution B      medium does not bring the other work under the scope of these      terms.   =   4. You may copy and distribute the Program (or a portion or ;      derivative of it, under Paragraph 2) in object code or @      executable form under the terms of Paragraphs 1 and 2 above4      provided that you also do one of the following:  6         * accompany it with the complete correspondingA           machine-readable source code, which must be distributedC:           under the terms of Paragraphs 1 and 2 above; or,  E         * accompany it with a written offer, valid for at least three C           years, to give any third party free (except for a nominalh9           charge for the cost of distribution) a complete$D           machine-readable copy of the corresponding source code, toE           be distributed under the terms of Paragraphs 1 and 2 above; 
           or,   D         * accompany it with the information you received as to where?           the corresponding source code may be obtained.  (ThisuD           alternative is allowed only for noncommercial distribution@           and only if you received the program in object code or!           executable form alone.)o  D      Source code for a work means the preferred form of the work forB      making modifications to it.  For an executable file, complete=      source code means all the source code for all modules it*?      contains; but, as a special exception, it need not include >      source code for modules which are standard libraries that@      accompany the operating system on which the executable fileA      runs, or for standard header files or definitions files that %      accompany that operating system.   E   5. You may not copy, modify, sublicense, distribute or transfer the C      Program except as expressly provided under this General Public A      License.  Any attempt otherwise to copy, modify, sublicense,*9      distribute or transfer the Program is void, and will A      automatically terminate your rights to use the Program under A      this License.  However, parties who have received copies, or E      rights to use copies, from you under this General Public License*D      will not have their licenses terminated so long as such parties      remain in full compliance.p  C   6. By copying, distributing or modifying the Program (or any work ?      based on the Program) you indicate your acceptance of this 8      license to do so, and all its terms and conditions.  E   7. Each time you redistribute the Program (or any work based on the B      Program), the recipient automatically receives a license fromD      the original licensor to copy, distribute or modify the ProgramC      subject to these terms and conditions.  You may not impose any(C      further restrictions on the recipients' exercise of the rightsu      granted herein.  @   8. The Free Software Foundation may publish revised and/or newD      versions of the General Public License from time to time.  SuchC      new versions will be similar in spirit to the present version,cB      but may differ in detail to address new problems or concerns.  C      Each version is given a distinguishing version number.  If the D      Program specifies a version number of the license which applies<      to it and ``any later version'', you have the option ofD      following the terms and conditions either of that version or ofE      any later version published by the Free Software Foundation.  If B      the Program does not specify a version number of the license,C      you may choose any version ever published by the Free Software       Foundation.  D   9. If you wish to incorporate parts of the Program into other freeC      programs whose distribution conditions are different, write to =      the author to ask for permission.  For software which isaC      copyrighted by the Free Software Foundation, write to the Free E      Software Foundation; we sometimes make exceptions for this.  OurdD      decision will be guided by the two goals of preserving the freeD      status of all derivatives of our free software and of promoting1      the sharing and reuse of software generally.   .                                    NO WARRANTY  @  10. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NOD      WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE@      LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT?      HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM ``AS IS'' ?      WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, =      INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OFa?      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THExD      ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM ISB      WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE;      COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.e  B  11. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO INB      WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAYB      MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE?      LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, B      INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE ORD      INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSSE      OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BYuE      YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITHyE      ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEENo0      ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  1                       END OF TERMS AND CONDITIONSo  7 Appendix: How to Apply These Terms to Your New Programsy7 =======================================================   E   If you develop a new program, and you want it to be of the greatestnD possible use to humanity, the best way to achieve this is to make itD free software which everyone can redistribute and change under these terms.  F   To do so, attach the following notices to the program.  It is safestC to attach them to the start of each source file to most effectivelyrD convey the exclusion of warranty; and each file should have at leastG the ``copyright'' line and a pointer to where the full notice is found.   J      ONE LINE TO GIVE THE PROGRAM'S NAME AND A BRIEF IDEA OF WHAT IT DOES.'      Copyright (C) 19YY  NAME OF AUTHORl       I      This program is free software; you can redistribute it and/or modify I      it under the terms of the GNU General Public License as published by H      the Free Software Foundation; either version 1, or (at your option)      any later version.       uD      This program is distributed in the hope that it will be useful,C      but WITHOUT ANY WARRANTY; without even the implied warranty of B      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1      GNU General Public License for more details.        F      You should have received a copy of the GNU General Public License@      along with this program; if not, write to the Free Software>      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  C  Also add information on how to contact you by electronic and papert mail.i  A If the program is interactive, make it output a short notice like + this when it starts in an interactive mode:f  >      Gnomovision version 69, Copyright (C) 19YY NAME OF AUTHORN      Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.B      This is free software, and you are welcome to redistribute it9      under certain conditions; type `show c' for details.s  @  The hypothetical commands `show w' and `show c' should show the@ appropriate parts of the General Public License.  Of course, the@ commands you use may be called something other than `show w' andA `show c'; they could even be mouse-clicks or menu items--whatevery suits your program.   B You should also get your employer (if you work as a programmer) or? your school, if any, to sign a ``copyright disclaimer'' for theo7 program, if necessary.  Here a sample; alter the names:x  C      Yoyodyne, Inc., hereby disclaims all copyright interest in thenH      program `Gnomovision' (a program to direct compilers to make passes,      at assemblers) written by James Hacker.       '      SIGNATURE OF TY COON, 1 April 1989F      Ty Coon, President of Vice    That's all there is to it!  *9  *  There!  I've done it, and now my conscience is clear!a  *M  *  As the good license above says, folks, this code is in the public domain,oM  *  and is to be distributed under the terms of a permission notice identicalr)  *  to the GNU license.  So, here goes...s  *     nL  *      This program is free software; you can redistribute it and/or modifyL  *      it under the terms of the GNU General Public License as published byK  *      the Free Software Foundation; either version 1, or (at your option)l  *      any later version.  *      G  *      This program is distributed in the hope that it will be useful,aF  *      but WITHOUT ANY WARRANTY; without even the implied warranty ofE  *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See then4  *      GNU General Public License for more details.  *      I  *      You should have received a copy of the GNU General Public License C  *      along with this program; if not, write to the Free Software A  *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   *1  *  Now that that's done, let us on, let us on...m  *  *  features              :mI  *     1) Addition (+), Subtraction (-), Multiplication (*), Division (/)    *     2) Modulus (%), Power (^)O  *     3) Bitwise logical operators: bitwise AND (&), bitwise inclusive OR (|),y$  *        unary one's complement (~)K  *     4) 20 Math/Trigonometric functions: sin, cos, tan, asin, acos, atan,t@  *        sinh, cosh, tanh, exp (exponential), ln (natural log),G  *        log (base 10 log), sqrt (square root), ceil (ceiling), floor,t7  *        int/trunc (truncation), abs (absolute value), C  *        degtorad (degrees->radians), radtodeg (radians->degrees).aO  *        Two Date functions to convert between calendar dates and julian days:lF  *        caltojul (calendar->julian) and jultocal (julian->calendar).<  *        One '?'-for-help command to display a help screen.M  *     5) Temporary variables (as many as you want, with names as long as youn3  *        want) to store intermediate computations. P  *     6) This is a "portable" calculator in the sense that it's not specific toN  *        any operating system.  The yacc output should be compilable by any CP  *        compiler; this program has been tested on Unix, VAX/VMS and PC/MS-DOS,1  *        and has required no changes to compile. O  *     7) This program uses the simplest of input and output formats, and is indM  *        no way hardware dependent.  So, as long as it compiles and executes,N  *        without any problems, there are no other requirements for it to work  *        as advertised.G  *     8) All numbers are of the C floating-point type "double", which, F  *        according to the VAX C manual, has a range of 0.29*10^-38 toA  *        1.7*10^38, and has values precise to 16 decimal digits.rF  *     9) Allows any number of expressions on a line, separated by ';'?  *    10) icalc can now be run either interactively (when it ispB  *        invoked without any arguments, in which case the user isA  *        prompted for input) or in a command-line mode (when all=<  *        expressions to be computed are passed to icalc viaE  *        command-line "argv" arguments, in which case icalc computesrC  *        and prints the result of each expression -- exactly as ifd?  *        it had been entered interactively -- and then exits).l>  *        In the latter case, the user is supposed to delimit/)  *        separate the expressions by ';'e  *  *  limitations           : H  *     1) This is a simple calculator that works only in character mode.J  *        No jazzy graphics, no explanatory error messages, nothin' fancy.N  *     2) This calculator is only double precision and NOT infinite precision.  *  *  references            :t@  *    The "Bison" manual of the "Free Software Foundation, Inc."  *J  *************************************************************************  */y  C #include <math.h>  /* For math functions, cos(), sin(), etc.     */o  I /* #include "calc.h" */  /* Contains definition of `symrec'            */ J /* ^^^^^^^^^^^^^^^^^ instead of having another one-time-only include file,O  *                   the file itself has been physically included here       */   O /*-- calc.h -----------------------------------------------------------------*/o  C /* Data type for links in the chain of symbols.                  */Y
 struct symrecr {h7   char *name;  /* name of symbol                     */o7   int type;    /* type of symbol: either VAR or FNCT */s	   union {t7     double var;           /* value of a VAR          */l7     double (*fnctptr)();  /* value of a FNCT         */u
   } value;7   struct symrec *next;    /* link field              */n };   typedef struct symrec symrec;h  7 /* The symbol table: a chain of `struct symrec'.     */f extern symrec *sym_table;t   symrec *putsym (); symrec *getsym ();   #ifdef __VMS #include <descrip.h>$ static char symbol_value[2000]='\0'; int  next_place=0; int  out_vals=0;K #define max_out_vals 9  /* this limits the output to the first 10 values */r #endif  O /*-- end of calc.h ----------------------------------------------------------*/      # line 565 "icalc.y" typedef union  {> double     val;  /* For returning numbers.                  */> symrec  *tptr;   /* For returning symbol-table pointers     */
 } YYSTYPE; # define NUM 257 # define VAR 258 # define FNCT 259c # define NEG 260 #define yyclearin yychar = -1o #define yyerrok yyerrflag = 0, extern int yychar; extern short yyerrflag;t #ifndef YYMAXDEPTH #define YYMAXDEPTH 150 #endif YYSTYPE yylval, yyval; # define YYERRCODE 256   # line 628 "icalc.y"    O /*== additional C code ======================================================*/r   #include <stdio.h>   int interactive; char *sargs;  4 double caltojul();	/* calendar date -> julian day */4 double jultocal();	/* julian day -> calendar date */  + double degtorad();	/* degrees -> radians */o+ double radtodeg();	/* radians -> degrees */    double trunc();		/* truncate */i   main(argc, argv)
 	int argc;
 	char **argv;; {d*     char *version = "2.2V of 16-FEB-1996";- /*  char *version = "2.2 of 17-MAR-1992";  */ - /*  char *version = "2.1 of 16-MAR-1992";  */f- /*  char *version = "2.0 of 14-DEC-1991";  */p- /*  char *version = "1.1 of 16-AUG-1990";  */f- /*  char *version = "1.0 of  8-JUL-1990";  */o /* Mathog 16-FEB-1996mJ    Modified version puts each unnamed result into the symbol ICALC_OUT, ie     1.0 + 2.0  -> ICALC_OUT = 3.0-    1.0 + 2.0; 3.8* 2.0 -> ICALC_OUT = 3.0,7.6n7    1.0 + 2.0; 3.8* 2.0, 3*2 -> ICALC_OUT = 3.0,7.6, 9.0s */ #ifdef __VMS+ struct  dsc$descriptor_s  symbol_name_desc;f, struct  dsc$descriptor_s  symbol_value_desc;    4 symbol_name_desc.dsc$w_length = strlen("ICALC_OUT");. symbol_name_desc.dsc$a_pointer =  "ICALC_OUT";. symbol_name_desc.dsc$b_class =  DSC$K_CLASS_S;. symbol_name_desc.dsc$b_dtype =  DSC$K_DTYPE_T;   #endif     init_table ();   if (argc == 1) {     interactive = 1;     printf("IC> ");a
   } else {     interactive = 0;     /*M      * contruct a single string "sargs" comprising all argv strings in order,aM      * with a single space separating each argv element (this is not strictly N      * necessary since the user is supposed to separate all expressions passedK      * through argv with ';' already, but it may be useful in the future tor      * know this).K      * signal the end of the string with '\n' followed by NULL (the '\n' isyE      * required for the way ICALC works, and the NULL will act as ther7      * equivalent of an EOF in an interactive session).       */t1     sargs = (char *) malloc(strlen(argv[1]) + 2);c     strcpy(sargs, argv[1]);h     argc--;r     argv++;      while (--argc) {M         sargs = (char *) realloc(sargs, strlen(sargs)+1 + strlen(*++argv)+2); J         strcat(sargs, " ");	/* argv separator -- not strictly necessary */         strcat(sargs, *argv);s     }t+     sargs[strlen(sargs) + 1] = (char) NULL; $     sargs[strlen(sargs)]     = '\n';   }   
   yyparse ();f   #ifdef __VMS8   symbol_value_desc.dsc$w_length = strlen(symbol_value);2   symbol_value_desc.dsc$a_pointer =  symbol_value;1   symbol_value_desc.dsc$b_class =  DSC$K_CLASS_S;t1   symbol_value_desc.dsc$b_dtype =  DSC$K_DTYPE_T; 7   LIB$SET_SYMBOL(&symbol_name_desc,&symbol_value_desc);p #endif }   O /*---------------------------------------------------------------------------*/i   #define BEL	0x7   - yyerror (s)  /* Called by yyparse on error */,
      char *s;c {p(   printf ("%c%s\n", BEL, s);	/* Beep! */ }s  O /*---------------------------------------------------------------------------*/    struct initr {e   char *fname;   double (*fnct)();  };   struct init arith_fncts[]t   = {e       "sin",		sin,       "sinh",		sinh,       "asin",		asin,       "cos",		cos,       "cosh",		cosh,       "acos",		acos,       "tan",		tan,       "tanh",		tanh,       "atan",		atan,       "exp",		exp,       "ln",		log,e       "log",		log10,       "sqrt",		sqrt,       "ceil",		ceil,       "floor",		floor,       "int",		trunc,       "trunc",		trunc,       "abs",		fabs,        "caltojul",	caltojul,.       "jultocal",	jultocal,w       "degtorad",	degtorad,o       "radtodeg",	radtodeg,o       0,		0o     };  8 /* The symbol table: a chain of `struct symrec'.      */  symrec *sym_table = (symrec *)0;  O /*---------------------------------------------------------------------------*/e  8 init_table ()  /* puts arithmetic functions in table. */ {t   int i;   symrec *ptr;-   for (i = 0; arith_fncts[i].fname != 0; i++)a     {e0       ptr = putsym (arith_fncts[i].fname, FNCT);/       ptr->value.fnctptr = arith_fncts[i].fnct;,     }, }b  O /*---------------------------------------------------------------------------*/e   symrec * putsym (sym_name,sym_type)      char *sym_name;      int sym_type; {n   symrec *ptr;+   ptr = (symrec *) malloc (sizeof(symrec));l3   ptr->name = (char *) malloc (strlen(sym_name)+1);h   strcpy (ptr->name,sym_name);   ptr->type = sym_type;o9   ptr->value.var = 0; /* set value to 0 even if fctn.  */ )   ptr->next = (struct symrec *)sym_table;    sym_table = ptr;
   return ptr;n }d  O /*---------------------------------------------------------------------------*/r   symrec * getsym (sym_name)m      char *sym_name; {d   symrec *ptr;,   for (ptr = sym_table; ptr != (symrec *) 0;!        ptr = (symrec *)ptr->next)a)     if (strcmp (ptr->name,sym_name) == 0)r       return ptr;o   return 0;s }o  O /*---------------------------------------------------------------------------*/e   #include <ctype.h>   /*O  * This lexical analyzer has been hand-coded, but in return for its simplicity,uH  * it has the restriction that only single-character tokens are allowed.L  * For multiple-character tokens, you might consider replacing the following*  * 'yylex' with REAL lex-generated source.  */e   yylex()b {    int c;  9   /* Ignore whitespace, get first nonwhite character.  */s2   while ((c = my_getchar ()) == ' ' || c == '\t');     if (c == EOF)s
     return 0;r  9   /* Char starts a number => parse the number.         */s   if (c == '.' || isdigit (c))     {i       if (interactive) {         ungetc (c, stdin);#         scanf ("%lf", &yylval.val);o       } else {         sargs--;+         sscanf (sargs, "%lf", &yylval.val);r
         /*N          * move the sargs pointer to the spot where sscanf() left off scanning          */          move_sargs();u       }h       return NUM;u     }o  9   /* Char starts an identifier => read the name.       */u   if (isalpha (c))     {h       symrec *s;       static char *symbuf = 0;       static int length = 0;       int i;  .       /* Initially make the buffer long enough,          for a 40-character symbol name.  */       if (length == 0):         length = 40, symbuf = (char *)malloc (length + 1);         i = 0;       do	         {s3           /* If buffer is full, make it bigger.  */            if (i == length)
             {u               length *= 2;<               symbuf = (char *)realloc (symbuf, length + 1);
             }l3           /* Add this character to the buffer.   */Y7           symbuf[i++] = isupper(c) ? tolower(c) : c;	/*T 							 * "tolower" makesO 							 * variable names 							 * case-INsensitive 							 * by converting them 							 * ALL to lower-case.
 							 */3           /* Get another character.              */I           c = my_getchar ();	         }E&       while (c != EOF && isalnum (c));         if (interactive)         ungetc (c, stdin);
       else         sargs--;       symbuf[i] = '\0';S         s = getsym (symbuf);       if (s == 0)P!         s = putsym (symbuf, VAR);W       yylval.tptr = s;       return s->type;O     }E  3   /* Any other character is a token by itself.   */O   return c;  }.  O /*---------------------------------------------------------------------------*/N   my_getchar() {  	int c;H   	if (interactive)  		return getchar();R 	else { 
 		c = *sargs;I                 if (c) {                   sargs++;                   return c;                  } else                   return EOF;H 	} }R  O /*---------------------------------------------------------------------------*/A   move_sargs() {E 	/*NB 	 * At the point when this routine is called, the sargs pointer isE 	 * sitting at the beginning of a floating-point number (we also know F 	 * that the character at the head of this number is either a '.' or a
 	 * digit.E 	 * This routine should move the sargs pointer to the spot/point/charoG 	 * on the string where the preceding sscanf() call should have stopped=
 	 * scanning.=          */    	/*y! 	 * Floating-point number format:a: 	 *	[ + | - ] nnn [ . [ ddd ] ] [ { E | e } [ + | - ] nn ] 	 */   	/*cE 	 * I'm starting with the assumption that *sargs is either a digit or  	 * the character '.'  	 */   	while (isdigit(*sargs))
 		sargs++;   	switch (*sargs) { 		case '.':  			switch (*++sargs) {
 				case '0':r
 				case '1': 
 				case '2':o
 				case '3':i
 				case '4': 
 				case '5':h
 				case '6':a
 				case '7':i
 				case '8':a
 				case '9':r 					while (isdigit(*sargs)) 						sargs++;   					switch (*sargs) { 						case 'E':  						case 'e': 
 							break;( 						default: 							return; 					}
 				case 'E':f
 				case 'e':o 					break;i 				default: 					return; 			} 		case 'E':  		case 'e':n	 			break; 
 		default:
 			return; 	}  A 	/* If control has dropped to this point, *sargs is 'E' or 'e' */) 	switch (*++sargs) { 		case '+':  		case '-':g 			switch (*++sargs) {
 				case '0':w
 				case '1': 
 				case '2':T
 				case '3':w
 				case '4': 
 				case '5':y
 				case '6':H
 				case '7':I
 				case '8':T
 				case '9':  					break;  				default: 					return; 			} 		case '0':  		case '1':Y 		case '2':e 		case '3':o 		case '4':  		case '5':c 		case '6':  		case '7':h 		case '8':f 		case '9':o 			while (isdigit(*sargs)) 				sargs++;
 			return;
 		default:
 			return; 	} }   O /*---------------------------------------------------------------------------*/t   help() { D 	/* display a help screen of all supported commands and functions */  ] 	printf("Arithmetic Operators:                   Trig Functions (take radian arguments):\n");GN 	printf("+          Addition (plus)                        sin       sine\n");Y 	printf("-          Subtraction (minus)                    sinh      hyperbolic sine\n");;R 	printf("*          Multiplication (times)                 asin      arc sine\n");P 	printf("/          Division (divided by)                  cos       cosine\n");\ 	printf("%%          Modulus (remainder)                    cosh      hyperbolic cosine\n");T 	printf("^          Power (raised to)                      acos      arc cosine\n");Q 	printf("Bitwise Logical Operators:                        tan       tangent\n");g\ 	printf("&          bitwise AND                            tanh      hyperbolic tangent\n");U 	printf("|          bitwise inclusive OR                   atan      arc tangent\n");'E 	printf("~          unary one's complement       Math Functions:\n");tX 	printf("Date Functions:                                   exp       exponentiation\n");U 	printf("caltojul   calendar to julian date                ln        natural log\n");cU 	printf("  Usage:   caltojul(yyyy, mm, dd)                 log       base 10 log\n");eU 	printf("  Returns: #days elapsed since October 15, 1582   sqrt      square root\n");dQ 	printf("jultocal   julian to calendar date                ceil      ceiling\n");mO 	printf("  Usage:   jultocal(julian_date)                  floor     floor\n");rT 	printf("  Returns: date in yyyymmdd format                int,trunc truncation\n");X 	printf("  Eg:  caltojul(1989,12,31) <=> jultocal(148732)  abs       absolute value\n");\ 	printf("Help Functions:                                   degtorad  degrees -> radians\n");\ 	printf("?          Help (print this screen)               radtodeg  radians -> degrees\n"); }   O /*---------------------------------------------------------------------------*/    /*6  * function to convert calender dates to julian dates.4  * (originally adapted from ACM, Oct '68, page 657).:  * This function assumes dayzero=yrmoda/julian/spss/sir =>*  * assumes idayzer=2299160 (Oct 15, 1582).  */    double caltojul(yyyy, mm, dd)u 	double yyyy, mm, dd;r { 6 	long idayzer, i, j, k, ci2j;	/* DON'T use "unsigned"!( 					 * ci2j calculation will blow up */   	idayzer = 2299160;(
 	i = yyyy; 	j = mm; 	k = dd;  @ 	ci2j = k-32075+1461*(i+4800+(j-14)/12)/4+367*(j-2-(j-14)/12*12)- 		/12-3*((i+4900+(j-14)/12)/100)/4 - idayzer;n   	return( (double) ci2j );t }   O /*---------------------------------------------------------------------------*/,   #ifndef abs > #define abs(x) ((x) < 0 ? (-(x)) : (x)) 		  /* absolute val */ #endif  O /*---------------------------------------------------------------------------*/,   double jultocal(jd)r 	double jd;  {  	/*a5 	 * function to convert julian days to calendar datesa 	 * (converse of caltojul)  ' 	 * idayzer    -- julian day-one offseta: 	 * i,j,k,l,n  -- integer ease transcription of algorithm 4 	 * dd,mm,yyyy -- day,month,year digits respectively. 	 * jd         -- incoming integer julian date@ 	 * jdz        -- local integer julian date  has dayzero addedon  ; 	 * converts julian date 'jd' with specifiable first day to 1 	 * gregorian date with output format 'yyyymmdd'. E 	 * uses acm algorithm by hf fliegel, and tc van flandern acm vol 11,d 	 * #10,oct68.  ? 	 * dayone is a string indicating first julian day of calendar. B 	 * algorithm uses prehistoric day-one, so 2299161 is oct 15, 1582" 	 * used by spss/sir for base date 	 */  0 	long idayzer, jdz, i, j, k, l, n, yyyy, mm, dd;   	idayzer = 2299160;     	jdz = abs((long) jd) + idayzer;  - 	/* i is julian year, j is month, k is day */*   	l = jdz + 68569;r 	n = 4*l/146097; 	l = l - (146097*n + 3)/4; 	i = 4000*(l+1)/1461001; 	l = l - 1461*i/4 + 31;r 	j = 80*l/2447;3 	k = l - 2447*j/80;0
 	l = j/11; 	j = j + 2 - 12*l; 	i = 100*(n - 49) + i + l;  
 	yyyy = i;
 	mm   = j;
 	dd   = k;  3 	return( (double) (yyyy * 10000 + mm * 100 + dd) );n }t  O /*---------------------------------------------------------------------------*/a  ! #define PI 3.14159265358979323846r  O /*---------------------------------------------------------------------------*/a   double degtorad(x)
 	double x; {m+ 	return( x * (PI / 180.0) );	/* deg->rad */c }m  O /*---------------------------------------------------------------------------*/    double radtodeg(x)
 	double x; { + 	return( x * (180.0 / PI) );	/* rad->deg */  }e  O /*---------------------------------------------------------------------------*/    double trunc(x) 
 	double x; { $ 	return( (long) x );		/* truncate */ }s  O /*== end of additional C code ===============================================*/s short yyexca[] ={* -1, 1, 	0, -1,u 	-2, 0,o 	};o # define YYNPROD 26T # define YYLAST 250  short yyact[]={s  2    3,  13,  25,  22,  23,  26,  11,  46,  20,  18,2   47,  19,  27,  21,  22,  23,  14,  17,  43,  20,2   18,  44,  19,  16,  21,   4,   2,   1,  22,  23,2   13,   0,  49,  20,  18,  11,  19,   0,  21,  22,2   23,   0,   0,  42,  20,  18,   0,  19,   0,  21,2    0,  22,  23,   6,   0,   0,  20,  18,   0,  19,2   25,  21,  22,  23,  22,  15,   0,  20,  18,  20,2   19,  25,  21,  22,  21,   0,   0,   0,  20,  18,2    0,  19,   0,  21,   0,  25,   0,  12,   0,   0,2   24,   0,   0,   0,   0,   0,  25,   0,   0,   0,2    0,  24,   0,   0,   0,   0,   0,   0,  25,   0,2    0,   0,   0,   0,   0,  24,  12,   0,   0,  25,2    7,  25,   0,   0,   0,   0,  24,   0,   0,   0,2   25,   0,  28,  29,  30,   0,  31,   0,  24,  32,2   33,  34,  35,  36,  37,  38,  39,  40,  41,   0,2    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,2    0,   0,   0,   0,   0,  45,   0,   0,  48,   0,2    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,2    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,2    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,2    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,2    0,   0,   0,   0,   0,   0,   0,   0,   8,   9,2   10,   0,   0,   0,   0,   0,   0,   0,   0,   0,2    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,4    0,   0,   0,   0,   0,   0,   5,   8,   9,  10 }; short yypact[]={  6 -1000, -10,-1000,-1000,   6,  13,   7,  14,-1000, -56,5  -28, -39, -39, -39,-1000, -39,-1000,-1000, -39, -39,c2  -39, -39, -39, -39, -39, -39, -39, -39, -92, -92,2    2,  14,  27,  27, -92, -92, -92,  36,  25, -92,8   14, -23,-1000,-1000, -39, -34,-1000, -39,  -9,-1000 }; short yypgo[]={2      0, 120,  27,  26,  25 };F short yyr1[]={  2    0,   2,   2,   3,   3,   3,   3,   4,   4,   1,2    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,     1,   1,   1,   1,   1,   1 }; short yyr2[]={  2    0,   0,   2,   1,   2,   2,   2,   1,   3,   1,2    1,   3,   4,   6,   8,   3,   3,   3,   3,   3,     3,   3,   2,   2,   3,   3 }; short yychk[]={=  3 -1000,  -2,  -3,  10,  -4, 256,  63,  -1, 257, 258,v2  259,  45, 126,  40,  10,  59,  10,  10,  43,  45,2   42,  47,  37,  38, 124,  94,  61,  40,  -1,  -1,2   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,4   -1,  -1,  41,  41,  44,  -1,  41,  44,  -1,  41 }; short yydef[]={b  2    1,  -2,   2,   3,   0,   0,   0,   7,   9,  10,2    0,   0,   0,   0,   4,   0,   5,   6,   0,   0,2    0,   0,   0,   0,   0,   0,   0,   0,  22,  23,2    0,   8,  15,  16,  17,  18,  19,  20,  21,  24,4   11,   0,  25,  12,   0,   0,  13,   0,   0,  14 };   #ifndef lintD static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83"; #endif not lint*   #o # define YYFLAG -1000f # define YYERROR goto yyerrlab # define YYACCEPT return(0)T # define YYABORT return(1)   /*	parser for yacc output	*/   #ifdef YYDEBUG& int yydebug = 0; /* 1 for debugging */ #endif: YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */1 int yychar = -1; /* current input token number */y( int yynerrs = 0;  /* number of errors *// short yyerrflag = 0;  /* error recovery flag */c   yyparse() {=   	short yys[YYMAXDEPTH];_ 	short yyj, yym; 	register YYSTYPE *yypvt;m$ 	register short yystate, *yyps, yyn; 	register YYSTYPE *yypv; 	register short *yyxi;  
 	yystate = 0; 
 	yychar = -1;"
 	yynerrs = 0;l 	yyerrflag = 0;t 	yyps= &yys[-1]; 	yypv= &yyv[-1];  7  yystack:    /* put a state and value onto the stack */a   #ifdef YYDEBUGB 	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar ); #endifQ 		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }a 		*yyps = yystate;	 		++yypv;y 		*yypv = yyval;    yynewstate:   	yyn = yypact[yystate];a  6 	if( yyn<= YYFLAG ) goto yydefault; /* simple state */  2 	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;9 	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;   = 	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */l 		yychar = -1; 		yyval = yylval;s 		yystate = yyn;" 		if( yyerrflag > 0 ) --yyerrflag; 		goto yystack;  		}     yydefault:l 	/* default state action */t  # 	if( (yyn=yydef[yystate]) == -2 ) {s5 		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0; $ 		/* look through exception table */  S 		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */    		while( *(yyxi+=2) >= 0 ){_ 			if( *yyxi == yychar ) break;e 			}5 		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */e 		}s   	if( yyn == 0 ){ /* error */+ 		/* error ... attempt to resume parsing */l   		switch( yyerrflag ){  ! 		case 0:   /* brand new error */l   			yyerror( "syntax error" );  		yyerrlab: 
 			++yynerrs;-  	 		case 1:-: 		case 2: /* incompletely recovered error ... try again */   			yyerrflag = 3;   ; 			/* find a state where "error" is a legal shift action */r   			while ( yyps >= yys ) {& 			   yyn = yypact[*yyps] + YYERRCODE;F 			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){A 			      yystate = yyact[yyn];  /* simulate a shift of "error" */n 			      goto yystack;
 			      } 			   yyn = yypact[*yyps];  @ 			   /* the current yyps has no shift onn "error", pop stack */   #ifdef YYDEBUG] 			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );e #endif
 			   --yyps; 
 			   --yypv;s 			   }   E 			/* there is no state on the stack with an error shift ... abort */u  	 	yyabort: 
 			return(1);a    1 		case 3:  /* no shift yet; clobber input char */u   #ifdef YYDEBUGG 			if( yydebug ) printf( "error recovery discards char %d\n", yychar );  #endif  @ 			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */ 			yychar = -1; 7 			goto yynewstate;   /* try again in the same state */-   			}   		}-  " 	/* reduction by production yyn */   #ifdef YYDEBUG* 		if( yydebug ) printf("reduce %d\n",yyn); #endif 		yyps -= yyr2[yyn]; 		yypvt = yypv;  		yypv -= yyr2[yyn]; 		yyval = yypv[1];
 		yym=yyn;. 			/* consult goto table to find next state */ 		yyn = yyr1[yyn]; 		yyj = yypgo[yyn] + *yyps + 1;-Y 		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];  		switch(yym){ 			  case 3:t # line 592 "icalc.y"3 { if (interactive) printf("IC> ");         } break;t case 4:  # line 593 "icalc.y"3 { if (interactive) printf("IC> ");         } break;t case 5:  # line 594 "icalc.y"
 { yyerrok;H                        if (interactive) printf("IC> ");         } break; case 6:  # line 596 "icalc.y"% { help();	/* display a help screen */-H                        if (interactive) printf("IC> ");         } break; case 7:_ # line 601 "icalc.y" { .   printf("        %.10g\n", yypvt[-0].val);    #ifdef __VMS   if(out_vals <= max_out_vals){r9     sprintf(symbol_value,"        %.10g", yypvt[-0].val); $     next_place=strlen(symbol_value);     out_vals++;-   }- #endif } break; case 8:- # line 602 "icalc.y". { printf("        %.10g\n", yypvt[-0].val);    #ifdef __VMS   if(out_vals <= max_out_vals){ Q     sprintf(symbol_value + strlen(symbol_value),",        %.10g", yypvt[-0].val);l$     next_place=strlen(symbol_value);     out_vals++;s   }r #endif } break; case 9:' # line 605 "icalc.y"= { yyval.val = yypvt[-0].val;                         } break;  case 10: # line 606 "icalc.y"> { yyval.val = yypvt[-0].tptr->value.var;              } break; case 11: # line 607 "icalc.y"G { yyval.val = yypvt[-0].val; yypvt[-2].tptr->value.var = yypvt[-0].val;f=                                printf("        %s = %.10g\n", _                                  yypvt[-2].tptr->name, yypvt[-0].val);                 } break;  case 12: # line 610 "icalc.y"I { yyval.val = (*(yypvt[-3].tptr->value.fnctptr))(yypvt[-1].val); } break;r case 13: # line 611 "icalc.y"X { yyval.val = (*(yypvt[-5].tptr->value.fnctptr))(yypvt[-3].val, yypvt[-1].val); } break; case 14: # line 612 "icalc.y"g { yyval.val = (*(yypvt[-7].tptr->value.fnctptr))(yypvt[-5].val, yypvt[-3].val, yypvt[-1].val); } break;i case 15: # line 613 "icalc.y"H { yyval.val = yypvt[-2].val + yypvt[-0].val;                    } break; case 16: # line 614 "icalc.y"H { yyval.val = yypvt[-2].val - yypvt[-0].val;                    } break; case 17: # line 615 "icalc.y"H { yyval.val = yypvt[-2].val * yypvt[-0].val;                    } break; case 18: # line 616 "icalc.y"H { yyval.val = yypvt[-2].val / yypvt[-0].val;                    } break; case 19: # line 617 "icalc.y"H { yyval.val = fmod(yypvt[-2].val, yypvt[-0].val);               } break; case 20: # line 618 "icalc.y"H { yyval.val = ((int) yypvt[-2].val) & ((int) yypvt[-0].val);    } break; case 21: # line 619 "icalc.y"H { yyval.val = ((int) yypvt[-2].val) | ((int) yypvt[-0].val);    } break; case 22: # line 620 "icalc.y"= { yyval.val = -yypvt[-0].val;                        } break;& case 23: # line 621 "icalc.y"= { yyval.val = ~((int) yypvt[-0].val);                } break;- case 24: # line 622 "icalc.y"H { yyval.val = pow (yypvt[-2].val, yypvt[-0].val);               } break; case 25: # line 623 "icalc.y"= { yyval.val = yypvt[-1].val;                         } break;  		}e0 		goto yystack;  /* stack new state and value */   	}