#  Program Name            : CVTMAIL.PL
#    Original Author       : JLAURET
#    Date                  : 22-Jan-2000
#    Program Description   : Convert VMS-style mail list produced by
#                          : EXTRACT/ALL into a MHonArc compatible input file.
#  References
#    Modules Referenced    : Requires Date::Manip

use Date::Manip;  

 $filin = "";

 if( $#ARGV != -1){
   $filin = $ARGV[0];
 } else {
   while( $filin eq ""){
     print "Input File : ";
     chomp($filin = <STDIN>);
   }
 }
 if( $#ARGV > 0){
   $filout = $ARGV[1];
 } else {
   $filout = $filin."_cvt";
 }
 
 print "MHCvtMail :: Input [$filin], Output [$filout]\n";


 open(FI,"$filin")   || die "MHCvtMail :: Could not open $filin as read\n";
 open(FO,">$filout") || die "MHCvtMail :: Failed to open $filout as write\n";

 $type  = 0;
 $count = 0;
 $new   = (1==0);

 while ( defined($line = <FI>)){
   chomp($line);
   if( $line eq chr(12) ){
     $count++;
     $new = (1 == 1);
   } else {
     if( $new){
       # Next line after a new mail
       $line  =~ s/\s+/ /g;
       @items = split(" ",$line);
       $date  = $items[2];
       $time  = $items[3];

       $time  =~ s/\..*/$1/;
       $date  =~ s/-/\//;
       $date  = &ParseDate($date);

       $host  = &hostname();

       $from  = $items[1];
       if (index($from,"::") == -1){
	 # Internet-like adress
	 $type  = 1;
	 $from  =~ s/SMTP\%//;
	 $from  =~ s/IN\%//;
	 $from  =~ s/MX\%//;
	 $from  =~ s/\"//g;
       } else {
	 # Decnet address. Convert it into Internet like adress
	 $type  = 2;
	 @items = split(":",$from);
	 if( ! defined($NODES{$items[0]}) ){
	   # Expensive but done once
	   $tmp = `write sys\$output f\$getsyi("HW_NAME","$items[0]")`;
	   if( substr($tmp,0,1) eq "%"){
	     # Error occured. Cannot solve it. LEave it as is
	     $NODES{$items[0]} = lc($items[0]);
	   } else {
	     # Same cluster. Assume same domain
	     $tmp = index($host,"\.");
	     $tmp = substr($host,$tmp+1,length($host)-$tmp);
	     $NODES{$items[0]} = lc($items[0]).".$tmp";
	   }
	 }
	 $from = "$items[2]\@$NODES{$items[0]}";
       }
       $Nid = &convert2Id($host);

       if($count > 1){ print FO "\n";}
       print FO "From $from ".&UnixDate($date,"%a %b %e $time %Y")."\n";
       print FO "Received: by $host id $Nid; ".
	 &UnixDate($date,"%a, %b %e $time %Y")."\n";

       $new = (1==0);
       $i = 1;
     } else {
       # Not a new Email. Either DECNET like or regular

       if($type == 1){
	 # The first 5 line are to be ignored
	 if( $i > 5){
	   # Just to be sure
	   $line =~ s/^Message-ID/Message-Id/;
	 } else {
	   goto NEXT;
	 }
       } elsif ($type == 2) {
	 if($i == 1 ){
	   # Some extra dummy stuff to make MHonarc happy
	   print FO "From: <$from>\n";
	   print FO "Reply-To: $from\n";
	   print FO "Date: ".&UnixDate($date,"%a %b %e $time %Y")."\n";
	   print FO "Message-Id: <cvtmail.Patch.VMSMAIL.",int(rand(10000000)),">\n";
	   if ($line =~ /^To\:/){
	     $line =~ s/\s+/ /g;
	     @items= split(" ",$line);
	     print FO "To: $items[1]\@$host\n";
	     goto NEXT;
	   }
	 } elsif ($i == 2) {
	   if ($line =~ /^CC\:/){
	     # In case of empty CC field, strip it out.
	     $line =~ s/\s+/ /g;
	     @items= split(" ",$line);
	     if( ! defined($items[1]) ){
	       goto NEXT;
	     }
	   }
	 } elsif ($i == 3) {
	   # Change VMS "Subj" to "Subject"
	   $line =~ s/^Subj\:/Subject\:/;
	 }
       }
       print FO "$line\n";
       NEXT:
       $i++;
     }
   }
 }

 if( $count != 0){
   print "MHCvtMail :: Formatted $count VMS Emails\n";
 }

 

 
 
 
 
sub hostname
{
  my($node);

  if( ! defined($HOSTNAME) ){
    $node = $ENV{'MULTINET_HOST_NAME'};
    if( $node eq ""){
      $node = $ENV{'UCX\$INET_HOST'};
      if( $node eq ""){
	$node = $ENV{'INTERNET_HOST_NAME'};
	if($node eq ""){
	  $node = $ENV{'TCPWARE_DOMAINNAME'};
	  if($node eq ""){
	    $node = $ENV{'ARPANET_HOST_NAME'};
	  } else {
	    $node = "received.by.unknown.foo";
	  }
	}
      }
    }
    $HOSTNAME = $node;
  }
  $HOSTNAME;
}


# Arbitrary
sub convert2Id
{
  my($node) = @_;
  my($sum);

  if( ! defined($CONVERTED{$node}) ){
    $sum = 0;
    for($i=0 ; $i < length($node) ; $i++){
      $sum += ord(substr($node,$i,1));
    }
    $CONVERTED{$node} = sprintf("%8.8X",$sum);
  }
  $CONVERTED{$node};
}


