/*
 * ASNObject.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.asn1;

import java.io.IOException;

/**
 * This class implements the base ASN.1 object.
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public class ASNObject
{
	protected int tag;

	protected byte[] content = null;

	/**
	 * Creates an ASNObject; to be called by subclasses.
	 */
	protected ASNObject()
	{
	}

	/**
	 * Creates an ASNObject with known tag and content.
	 * @param tag the tag (type) of the object
	 * @param content the contents of the object
	 */
	public ASNObject(int tag, byte[] content)
	{
		this.tag = tag;
		this.content = content;
	}

	/**
	 * Returns the content of the object.
	 * @return the content of the object
	 */
	public byte[] getContent() throws IOException
	{
		return content;
	}

	/**
	 * Returns the string representation of the object.
	 * @return the string representation of the object
	 */
	public String toString()
	{
		return "TAG " + tag;
	}

	/**
	 * Returns the string representation of the object.
	 * @param prefix the string to insert before every line of the representation
	 * @return the string representation of the object
	 */
	protected String toString(String prefix)
	{
		return prefix + toString();
	}
}
