/*
 * ASNObjectID.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.asn1;

import java.io.IOException;
import java.util.StringTokenizer;

/**
 * This class implements an ASN.1 OID object.
 * Note: the encoding/decoding of this object is incomplete!
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public class ASNObjectID extends ASNObject
{
	private int[] oid;

	/**
	 * Creates an ASNObjectID.
	 * @param oid the int array holding the components of ASN.1 object id
	 */
	public ASNObjectID(int[] oid)
	{
		tag = DER.ASN_OID;
		if (oid == null)
			throw new IllegalArgumentException("oid is null");

		if (oid.length < 2)
			throw new IllegalArgumentException("oid length is too small");

		if (oid[0] < 0 || oid[0] > 2)
			throw new IllegalArgumentException("oid value 1 must be 0, 1 or 2");

		if (oid[1] < 0 || oid[1] > 39)
			throw new IllegalArgumentException("oid value 2 must be between 0 and 39");

		for (int i = 2; i < oid.length; i++)
			if (oid[i] < 0)
				throw new IllegalArgumentException("oid value " + (i+1) + " must be greater than 0");

		this.oid = (int[]) oid.clone();
	}

	/**
	 * Creates an ASNObjectID.
	 * @param oid the string representation of the ASN.1 object id
	 */
	public ASNObjectID(String oid)
	{
		tag = DER.ASN_OID;
		if (oid == null)
			throw new IllegalArgumentException("oid is null");

		StringTokenizer st = new StringTokenizer(oid, ".");

		int count = st.countTokens();
		if (count == 0)
			throw new IllegalArgumentException("oid length is zero");

		int[] tmp = new int[count];

		for (int i = 0; i < count; i++)
			tmp[i] = Integer.valueOf(st.nextToken()).intValue();

		if (tmp[0] < 0 || tmp[0] > 2)
			throw new IllegalArgumentException("oid value 1 must be 0, 1 or 2");

		if (tmp[1] < 0 || tmp[1] > 39)
			throw new IllegalArgumentException("oid value 2 must be between 0 and 39");

		for (int i = 2; i < tmp.length; i++)
			if (tmp[i] < 0)
				throw new IllegalArgumentException("oid value " + (i+1) + " must be greater than 0");

		this.oid = tmp;
	}

	/**
	 * Creates an ASNObjectID.
	 * @param content the DER representation of the object id
	 */
	public ASNObjectID(byte[] content)
	{
		tag = DER.ASN_OID;
		this.content = content;
		// decode the content to the oid array
	}


	/**
	 * Returns the DER representation of the object id.
	 * @return the DER representation of the object id
	 */
	public byte[] getContent()
	{
		if (content == null)
		{
			// encode the content
			
		}
		return content;
	}

	/**
	 * Returns the string representation of the object.
	 * @return the string representation of the object
	 */
	public String toString()
	{
		return "OID";
	}
}
