/*
 * ASNOctetString.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.asn1;

import java.io.IOException;

/**
 * This class implements an ASN.1 PRINTABLESTRING object
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public class ASNPrintableString extends ASNObject
{
	private char[] string;

	/**
	 * Creates an ASNPrintableString.
	 * @param c the char array representing the printable string
	 */
	public ASNPrintableString(char[] c)
	{
		tag = DER.ASN_PRINTABLESTRING;
		string = (char[]) c.clone();
		content = new byte[string.length];
		for (int i = 0; i < string.length; i++)
			content[i] = (byte) string[i];
	}

	/**
	 * Creates an ASNPrintableString.
	 * @param content the byte representation of the printable string
	 */
	public ASNPrintableString(byte[] content)
	{
		tag = DER.ASN_PRINTABLESTRING;
		this.content = content;
		string = new char[content.length];
		for (int i = 0; i < content.length; i++)
			string[i] = (char) content[i];
	}

	/**
	 * Returns the string representation of the object.
	 * @return the string representation of the object
	 */
	public String toString()
	{
		return "PRINTABLE STRING " + new String(string);
	}
}
