/*
 * ASNSequence.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.asn1;

import java.io.*;
import java.util.*;

/**
 * This class implements an ASN.1 SEQUENCE or SEQUENCE OF object.
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public class ASNSequence extends ASNConstruct
{
	/**
	 * Creates an ASN.1 SEQUENCE constructed object.
	 * @param objs the objects from which to make the sequence
	 * @see ASNObject
	 */
	public ASNSequence(ASNObject[] objs)
	{
		super(DER.ASN_CONSTRUCTED | DER.ASN_SEQUENCE, objs);
	}

	/**
	 * Creates an ASN.1 SEQUENCE constructed object.
	 * @param vect the Vector containsing objects from which to make the sequence
	 * @see ASNObject
	 * @see java.util.Vector
	 */
	public ASNSequence(Vector vect)
	{
		super(DER.ASN_CONSTRUCTED | DER.ASN_SEQUENCE, vect);
	}

	/**
	 * Returns the string representation of the sequence.
	 * @return the string representation of the sequence
	 */
	public String toString()
	{
		return toString("");
	}

	/**
	 * Returns the string representation of the sequence.
	 * @param prefix the string to insert before every line of the representation
	 * @return the string representation of the sequence
	 */
	protected String toString(String prefix)
	{
		String indent = prefix + " ";

		StringBuffer buf = new StringBuffer();

		buf.append(prefix);
		buf.append("SEQUENCE\n");

		for (int i = 0; i < objs.length; i++)
		{
			buf.append(objs[i].toString(indent));
			if (i < objs.length-1)
				buf.append("\n");
		}
		return buf.toString();
	}
}
