/*
 * DER.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.asn1;

import java.io.*;

/**
 * This class implements the ASN.1 Distinguished Encoding Rules.
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public final class DER
{
	/**
	 * Holds string which can be used to identify the encoding format.
	 */
	public static final String
		ASNFORMAT = "ASN.1";

	/**
	 * ASN.1 DER Tag definitions.
	 */
	protected static final int
		ASN_INTEGER = 0x2,
		ASN_BITSTRING = 0x3,
		ASN_OCTETSTRING = 0x4,
		ASN_NULL = 0x5,
		ASN_OID = 0x6,
		ASN_SEQUENCE = 0x10,
		ASN_SET = 0x11,
		ASN_PRINTABLESTRING = 0x13,
		ASN_IA5STRING = 0x16,
		ASN_UTCTIME = 0x17,
		ASN_GENERALIZEDTIME = 0x18,
		ASN_CONSTRUCTED = 0x20;

	/**
	 * Returns the DER encoding of an ASNObject.
	 * @param obj the object to encode
	 * @return the DER encoding if obj
	 */
	public static final byte[] encode(ASNObject obj) throws IOException
	{
		ByteArrayOutputStream bs = new ByteArrayOutputStream();
		DEROutputStream ds = new DEROutputStream(bs);

		ds.writeObject(obj);
		ds.close();
		bs.close();

		return bs.toByteArray();
	}

	/**
	 * Returns an ASNObject decoded from a DER byte represenation
	 * @param input the DER representation of the object
	 * @return the ASNObject decoded from the input
	 */
	public static final ASNObject decode(byte[] input) throws IOException
	{
		ByteArrayInputStream bs = new ByteArrayInputStream(input);
		DERInputStream ds = new DERInputStream(bs);

		ASNObject tmp = ds.readObject();

		ds.close();
		bs.close();

		return tmp;
	}
}
