/*
 * DHKey.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 1999-2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.crypto;

import java.math.BigInteger;
import javax.crypto.spec.DHParameterSpec;

/**
 * This class is the base for Diffie-Hellman keys (public & private).
 * @author Bob Deblier <bob@virtual-unlimited.com>
 */
public abstract class DHKey extends DHParameterSpec implements javax.crypto.interfaces.DHKey, java.security.Key
{
	private static final String
		ALGORITHM = "DH";

	protected DHKey(DHParameterSpec params)
	{
		super(params.getP(), params.getG(), params.getL());
	}

	protected DHKey(BigInteger p, BigInteger g)
	{
		super(p, g);
	}

	public DHParameterSpec getParams()
	{
		return this;
	}

	public String getAlgorithm()
	{
		return ALGORITHM;
	}

	public byte[] getEncoded()
	{
		return null;
	}

	public String getFormat()
	{
		return null;
	}

	public String toString()
	{
		return "P=" + getParams().getP().toString(16) + "\nG=" + getParams().getG().toString(16);
	}
}
