/*
 * DLKey.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.crypto;

import java.math.BigInteger;
import javax.crypto.spec.DHParameterSpec;
import com.beeyond.crypto.spec.DLParameterSpec;

/**
 * This class is the base for discrete logarithm keys (public & private).
 * <p>
 * <b>References:</b><br>
 * <ul>
 * <li>IEEE P1363 Draft
 * </ul>
 * <p>
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public abstract class DLKey extends DLParameterSpec implements com.beeyond.crypto.interfaces.DLKey, java.security.Key
{
	private static final String
		ALGORITHM = "DL";
		
	protected DLKey(DLParameterSpec params)
	{
		super(params.getP(), params.getQ(), params.getG(), params.getL());
	}

	protected DLKey(BigInteger p, BigInteger q, BigInteger g)
	{
		super(p, q, g);
	}

	public DHParameterSpec getParams()
	{
		return this;
	}

	public String getAlgorithm()
	{
		return ALGORITHM;
	}

	public byte[] getEncoded()
	{
		return null;
	}

	public String getFormat()
	{
		return null;
	}

	public String toString()
	{
		return "P=" + getP().toString(16) + "\nQ=" + getQ().toString(16) + "\nG=" + getG().toString(16);
	}
}
