/*
 * DLKeyPairGenerator.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 1999-2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.crypto;

import java.math.BigInteger;
import java.security.*;
import java.security.spec.*;
import javax.crypto.spec.*;
import com.beeyond.crypto.spec.DLParameterSpec;

/**
 * This class implements the generation of discrete logarithm keypairs.
 * <p>
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public class DLKeyPairGenerator extends DHKeyPairGenerator
{
	private static final String
		ALGORITHM = "DL",
		PROVIDER = "BeeCrypt";

	private static final InvalidAlgorithmParameterException NOELG = new InvalidAlgorithmParameterException("Not a DLParameterSpec");

	public KeyPair generateKeyPair()
	{
		if (params == null)
			return null;

		generateXY();
		return new KeyPair(new DLPublicKey((DLParameterSpec) params, y),
			new DLPrivateKey((DLParameterSpec) params, x));
	}

	public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException
	{
		if (params instanceof DLParameterSpec)
		{
			this.params = (DLParameterSpec) params;
			this.random = random;
		}
		else
			throw NOELG;
	}

	public void initialize(int keysize, SecureRandom random)
	{
		try
		{
			AlgorithmParameterGenerator apg = AlgorithmParameterGenerator.getInstance(ALGORITHM, PROVIDER);
			apg.init(keysize, random);
			this.params = (DLParameterSpec) apg.generateParameters().getParameterSpec(DLParameterSpec.class);
			this.random = random;
		}
		catch (Exception e)
		{
		}
	}
}
