/*
 * DLParameterGenerator.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.crypto;

import java.security.SecureRandom;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import com.beeyond.crypto.spec.DLGenParameterSpec;
import com.beeyond.crypto.spec.DLParameterSpec;

/**
 * This class implements the generation of discrete logarithm domain parameters.
 * <p>
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public class DLParameterGenerator extends DHParameterGenerator
{
	private static final String
		ALGORITHM = "DL";

	private DLGenParameterSpec genParamSpec = null;

	protected AlgorithmParameters engineGenerateParameters()
	{
		int primeSize = genParamSpec.getPrimeSize();

		generatePQG(genParamSpec.getPrimeSize(), genParamSpec.getFactorSize(), genParamSpec.getGenerateSubgroup());

		AlgorithmParameters ap = null;

		try
		{
			ap = AlgorithmParameters.getInstance(ALGORITHM, PROVIDER);
			ap.init(new DLParameterSpec(p, q, g, genParamSpec.getExponentSize()));
		}
		catch (Exception e)
		{
		}

		return ap;
	}

	protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException
	{
		if (genParamSpec instanceof DLGenParameterSpec)
		{
			this.genParamSpec = (DLGenParameterSpec) genParamSpec;
			this.random = random;
		}
		else
			throw new InvalidAlgorithmParameterException("Not a DLGenParameterSpec");
	}

	protected void engineInit(int size, SecureRandom random)
	{
		// get the default q size from a table?
		this.genParamSpec = new DLGenParameterSpec(size, size / 2, size, false);
		this.random = random;
	}
}
