/*
 * DLPrivateKey.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.crypto;

import java.io.*;
import java.math.BigInteger;
import com.beeyond.crypto.spec.DLParameterSpec;

/**
 * This class implements a discrete logarithm private key.
 * <p>
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public class DLPrivateKey extends DLKey implements com.beeyond.crypto.interfaces.DLPrivateKey
{
	private BigInteger x;

	public DLPrivateKey(DLParameterSpec params, BigInteger x)
	{
		super(params);
		this.x = x;
	}

	public DLPrivateKey(BigInteger p, BigInteger q, BigInteger g, BigInteger x)
	{
		super(p, q, g);
		this.x = x;
	}

	public BigInteger getX()
	{
		return x;
	}

	public String toString()
	{
		return super.toString() + "\nX=" + x.toString(16);
	}
}
