/*
 * ElGamalKey.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 1999-2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.crypto;

import java.math.BigInteger;
import com.beeyond.crypto.spec.DLParameterSpec;

/**
 * This class is the base for ElGamal keys (public & private)
 * <p>
 * Instead of deriving it from DHKey, we actually derive it from DLKey,
 * so that we can check the prime's properties if necessary.
 *
 * @author Bob Deblier <bob@virtual-unlimited.com>
 */
public abstract class ElGamalKey extends DLKey implements com.beeyond.crypto.interfaces.ElGamalKey
{
	private static final String
		ALGORITHM = "ElGamal";
		
	protected ElGamalKey(DLParameterSpec params)
	{
		super(params);
	}

	protected ElGamalKey(BigInteger p, BigInteger q, BigInteger g)
	{
		super(p, q, g);
	}

	public String getAlgorithm()
	{
		return ALGORITHM;
	}
}
