/*
 * HMacKeyFactory.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 1999-2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.crypto;

import java.security.*;
import java.security.spec.*;
import javax.crypto.*;
import javax.crypto.spec.*;

public abstract class HMacKeyFactory extends SecretKeyFactorySpi
{
	private static final InvalidKeySpecException
		NOTSECRETKEYSPEC = new InvalidKeySpecException("Not a SecretKeySpec");

	private String algorithm;
	private MessageDigest md;

	protected HMacKeyFactory(String algorithm) throws NoSuchAlgorithmException
	{
		this.algorithm = algorithm;
		md = MessageDigest.getInstance(algorithm.substring(0, algorithm.lastIndexOf("/")));
	}

	protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException
	{
		if (keySpec instanceof SecretKeySpec)
		{
			byte[] tmp = ((SecretKeySpec)keySpec).getEncoded();

			if (tmp.length > 64)
			{
				tmp = md.digest(tmp);
				md.reset();
			}

			return new SecretKeySpec(tmp, algorithm);
		}
		else
			throw NOTSECRETKEYSPEC;
	}

	protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException
	{
		if (keySpec.equals(SecretKeySpec.class))
		{
			byte[] tmp = key.getEncoded();
			if (tmp.length > 64)
			{
				tmp = md.digest(tmp);
				md.reset();
			}
			return new SecretKeySpec(tmp, algorithm);
		}
		else
			throw NOTSECRETKEYSPEC;
	}

	protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException
	{
		byte[] tmp = key.getEncoded();
		if (tmp.length > 64)
		{
			tmp = md.digest(tmp);
			md.reset();
		}
		return new SecretKeySpec(tmp, algorithm);
	}
}
