/*
 * PBECipher.java
 *
 * This interface is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package com.beeyond.crypto;

import java.security.MessageDigest;

/**
 * This class provides an interface for all ciphers that will be used in
 * Password Based Encryption.
 * <p>
 * <b>See also:</b>
 * <li><a href="http://www.rsalabs.com/pkcs/pkcs-5/index.html">PKCS#5 - Password-Based Crypto Standard</a>
 * <li><a href="http://www.rsalabs.com/pkcs/pkcs-12/index.html">PKCS#12 - Personal Information Exchange Syntax Standard</a>
 * <p>
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public interface PBECipher
{
	/**
	 * Returns the digest for key and iv derivation.
	 * @return the digest for key and iv derivation 
	 */
	public MessageDigest getDigest();
}
