/*
 * PBEWithSHAAndBlowfish.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package com.beeyond.crypto;

import java.security.*;
import javax.crypto.*;

/**
 * This class implements PBE with SHA-1 and Blowfish.
 * <p>
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public final class PBEWithSHAAndBlowfish extends BlowfishCipher implements PBECipher
{
	private MessageDigest md;

	/**
	 * Creates a PBEWithSHAAndBlowfish cipher
	 */
	public PBEWithSHAAndBlowfish()
	{
		try
		{
			md = MessageDigest.getInstance("SHA");
			engineSetMode("CBC");
			engineSetPadding("PKCS5Padding");
		}
		catch (NoSuchAlgorithmException nsae)
		{
			md = null;
			throw new ProviderException(nsae.getMessage());
		}
		catch (NoSuchPaddingException nspe)
		{
			md = null;
			throw new ProviderException(nspe.getMessage());
		}
	}

	/**
	 * Returns the digest for key and iv derivation.
	 * @return the digest for key and iv derivation 
	 */
	public MessageDigest getDigest()
	{
		return md;
	}
}
